## Find One and Update

This step allows ETL to poll a collection and read a record, while updating it to ensure other
processes do not read it too. This is an atomic operation, useful for constructing queues 
with multiple readers.

Here is an example:

We have a collection with records:

|Id|Status|Name|
|--|------|-----|
|1|Added|Hello|
|2|Added|World|
|3|Added|Again|

We have an incoming record with:
```
{
  "value": "Added",
  "newValue": "Seen"
}
```

We set up the step with Key=Status, Value Field=value, New Value Field=newValue, 
Sort Field=Name, Ascending=true

When we run this once, the collection is updated to contain `[3,Seen,Again]` and 
this is returned from the step 
(merged into the incoming record):
{
"value": "Added",
"newValue": "Seen",
"Id": 3,
"Status": "Added",
"Name": "Again"
}

This record was chosen because of the Sort order (Name, Ascending) which makes "Again" the first Name.

If we run the same step again, we will get a different result, because "Again" is now marked as "Seen"
and we are looking for Value "Added". Therefore this time we will get back `[1,Seen,Hello]` following 
the earlier logic.

### Structure
1 => 0..1

### Input
Records consisting of a key field, old value and new value, which must all be present for an update to happen

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection` - the collection to update

* `Key` - the field to use for identifying the record to read

* `Value Field` - the field in the incoming record which holds the value to look for

* `New Value Field` - the field in the incoming record which holds the value to update to

* `Sort Field` - the field in the target collection to use for sorting (to obtain the first result)

* `Ascending` - true if the sort should be ascending, else descending

### Output
A single record containing the incoming record with the found record merged into it 
(the found record may overwrite fields in the incoming record).  
If no record is found, there are no records output. 

#### Notes
* Even if multiple calls are made concurrently, the FindOneAndUpdate action is atomic, so only one
requester will see each record.

#### See Also
* MongoDB Updater

