## MongoDB Push

This step allows pushing of values into arrays in existing MongoDB records. For each record received, it will
use the `Keys` fields to select one or more records (at most one record if the key fields are unique).
It will then push the value of the `Value Field` into the `Array` field for those matching documents. 

If there are no `Keys` fields defined, the unset will apply to every record in the collection.
If any `Keys` field is missing from the input document, no update will be done. 
If the `Value Field` is missing from the input document, the array will not be changed. 

### Structure
N => 1

### Input
Records consisting of Key fields, which must all be present for a push to happen, along with a Value field 

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection` - the collection to update

* `Keys` - the list of key fields which is used to filter the records for pushing

* `Value Field` - the field in the input records to push onto the array of matching records

* `Array` - the name of the array field to push the value onto
 

### Output
A single record containing: 

* `elapsedTime` - how long the step took to run from the first to last document processed

* `count` - how many records were updated

#### Notes
* The keys criteria need not uniquely identify a single document in the target collection. 
If no match is found, there is nothing to update. If one match is found, one document is updated.
If many documents are found, they are all updated. 

* If multiple documents can be updated by one input record, the order of input records may be important, 
as one document could be updated several times in the course of processing the input.

* If the target array does not exist it will be created. However, if the target array exists but is a different type
(ie. not an array), then the MongoDB database will throw an exception. 

#### See Also
* MongoDB Updater
