## Integer Divide Separate Field

This step divides a record using a numerator and denominator ensuring that the sum across the separated
records matches the original numerator. An example makes this easier:

```
numerator = 100, denominator = 3
```

The output is the size of the denominator (3 records), the result of summing all three 
equals the numerator:

```
numerator = 100, denominator = 3, result = 34
numerator = 100, denominator = 3, result = 33
numerator = 100, denominator = 3, result = 33
```

Note the first result is 34 to ensure the three integers still add to 100.

### Structure
1 => N

### Input
Two field record with value as numerator and denominator

### Parameters
* Numerator Field - the field containing the value to be the dividend

* Denominator Field - the field containing the value to be the dividend

* Result Field - the field to contain the result

### Output
For each record in, the value of the denominator will determine the number of records out.
The sum of the results in these fields will equal the numerator.

#### See Also

* Integer Divide Remainder Field