## OCR Definition

This step defines the groups and fields for OCR. The JSON must be an object where the fields define the groups.

For example this definition defines one group **demo**.
```json
{
  "demo" : {
    "ocr" : {
      "label" : "DEMO",
      "fields" : [
        {
          "id" : "electricity_usage",
          "label" : "Electricity Usage (kWh)",
          "type" : "decimal"
        },
        {
          "id" : "water_usage",
          "label" : "Water Usage (Cu M)",
          "type" : "decimal"
        }
      ]
    }
  }
}
```

Note: if the incoming record contains elxPublic it will deep merge override the elxPublic produced by this step


### Structure
1 ⇒ 1

### Input
* No special requirements


### Parameters
* `JSON` - the JSON definition used for OCR

### Output
The input record with an **elxPublic** properties added containing the `JSON` definition and additional fields used internally by OCR

#### See Also

OCRSignature

OCRGroup

OCRCropImage

OCRCropPDF
