## ETL Queue Definition

This is a helper step to construct the necessary structure needed for running ETL Jobs
using `Add To Queue`.

You can construct this structure yourself, or else use this as a starting point and
perform substitutions before finally calling `Add To Queue`.

The output of this step will be a `request` field containing this structure 
(with example values included here):

```
{ "jobType": "etl", 
  "chainSet": "My Chainset",
  "chainName": "Example",
  "parameters": { "city": "Burnaby" }
}
```

### Structure
1 ⇒ 1

### Input
* No special input requirements

### Parameters

* `Chain Set` - the chain set to load

* `Chain Name` - the chain within the chain set to run.

* `Parameters` - a Json structure holding any parameters required by the Chain. This Json allows
    direct support for substitution, so use "city": "${CityName}" to include the field CityName 
    in your parameters.

### Output
The input record with a `request` nested document, holding the supplied field values

### Notes

### See Also

* Add to Queue
