## RML Queue Definition

This is a helper step to construct the necessary structure needed for rendering RML
using `Add To Queue`.

You can construct this structure yourself, or else use this as a starting point and
perform substitutions before finally calling `Add To Queue`.

The output of this step will be a `request` field containing this structure 
(with example values included here):

```
{ "jobType": "rml", 
  "path": "/ElixirSamples/Report/RML/Master-Detail Report.rml",
  "mimeType": "application/pdf",
  "parameters": { "city": "Burnaby" },
  "renderDetails": {}
}
```

### Structure
1 ⇒ 1

### Input
* No special input requirements

### Parameters

* `Path` - the path of the RML in the repository

* `Mime Type` - the mime-type to use when rendering. Defaults to application/pdf

* `Parameters` - a Json structure holding any parameters required by the RML. This Json allows
    direct support for substitution, so use "city": "${CityName}" to include the field CityName 
    in your parameters.

* `Render Details` - any special render details required by the chosen Mime Type, for example
    whether XLSX is Paged or Streamed. See the RML documentation for details.

### Output
The input record with a `request` nested document, holding the supplied field values

### Notes

### See Also

* Add to Queue
