## Add Tags

This step adds tags to a repository file or folder, identified by a Path

### Structure

1 => 1

### Input

A record containing a file or folder location string field (identified by the `Path Field` parameter) and
a tags field, which can be either a comma-separated string, or an array of strings. Each tag will be added
to the file or folder at the path identified.

### Parameters

* `Path Field` - The file or folder path to be tagged

* `Tags Field` - Either a string or array field holding the tags (comma delimited if in one string)

### Outputs

The incoming record is passed through with no changes on success. On failure, an "error" field will be added
highlighting the problem. The error will also be sent to the JobLog.

#### Notes

* The repository access rights will determine whether the file can be seen by the current user.

* Tags which are already present will be ignored 

* Tags can be prefixed by the username, eg: \[admin\]MyTag - such tags can only be added/removed by the corresponding user

#### See Also

* Get Tags

* Remove Tags

* Set Tags
