## Copy to Report Portal

This step copies repository files to the report portal. This step will work for all users, but only those with
mod-report-portal-admin privilege can use this step to copy files into other user's report portals. 

The user running the step must have read access to any files being copied. The resulting copy will be viewable by
the owner of the report portal it is copied to (and anyone they later choose to share it with).

### Structure

1 => 1

### Input

A record containing a file or folder location string field (identified by the `Path Field` parameter) and
an optional Owner Field. The Owner Field should be left blank if the target report portal belongs to the user running the ETL step.
Only those with mod-report-portal-admin privilege are allowed to use the Owner field to assign copies to other people's report portals.
If used, the Owner Field should point to the name of the user whose report portal is being altered.

This step will automatically remove any path prefix that matches "/User/<ownername>/" to produce shorter paths in the report portal.
Repository paths with other prefixes will be retained unchanged

### Parameters

* `Path Field` - The file to be copied (note folders are not supported, files must be copied individually)

* `Owner Field` - Only for mod-report-portal-admin use - assign the copy to a named user's report portal.

### Outputs

The incoming record is passed through with no changes on success. On failure, an "error" field will be added
highlighting the problem. The error will also be sent to the JobLog.

#### Notes

* The repository access rights will determine whether the file can be seen by the current user.

* Once copied into the report portal, the file will be readable by the owner of that portal and anyone they later share it with. 

#### See Also

