## Git Pull

This step reads a subtree of the repository from a git repository, along with metadata which allows tags 
and access control to be recreated from a matching `Git Push`.

This step is intended to be used in conjunction with `Git Push` to transfer repository contents efficiently between
systems, while providing via git a full version history of what has changed.

Files from the git repository are restored to their original locations, there is no mechanism to "re-target" files
to a different location.

This step requires mod-repository-admin to ensure all files (regardless of access rights) within the folder can be pulled.

### Structure

1 => 1

### Input

A record containing repository and branch fields.

### Parameters

* `Git Repository Field` - The git repository URL (usually in the format `git@git.example.com:somegroup/somerepo.git`)
    You may also use an {enc encoded string, or a {secret} reference here.

* `Git Branch Field` - The field holding the branch name to pull from
 
### Outputs

The incoming record is passed through with no changes. On failure, an error will be added to the JobLog.

#### Notes

#### See Also

* Git Push
