## Git Push

This step stores a subtree of the repository into a git repository, along with metadata which allows tags 
and access control to be recreated on a matching `Git Pull`.

This step is intended to be used in conjunction with `Git Pull` to transfer repository contents efficiently between
systems, while providing via git a full version history of what has changed.

This step requires mod-repository-admin to ensure all files (regardless of access rights) within the folder can be pushed.

### Structure

1 => 1

### Input

A record containing a folder location string field, along with repository and branch fields.

### Parameters

* `Path Field` - The folder to be pushed to git

* `Git Repository Field` - The git repository URL (usually in the format `git@git.example.com:somegroup/somerepo.git`)
  You may also use an {enc encoded string, or a {secret} reference here. 

* `Git Branch Field` - The field holding the branch name to push to
 
### Outputs

The incoming record is passed through with no changes. On failure, an error will be added to the JobLog.

#### Notes

#### See Also

* Git Pull
