## S3 Generate Expiring URL

This step generates a URL that can be used for a limited time to reads bytes from AWS S3

### Structure
1 => 1

### Input

Each incoming record should contain a path to read.

### Parameters

* `Bucket` - the name of the bucket information to use from System Settings AWS Integration.

* `Path Field` - the incoming string field holding the path to be appended to the bucket path.

* `Expire After` - how long the URL should remain available. The maximum supported by AWS is 7 days. The following units are available: week(s), day(s), hour(s), minute(s), second(s), for example "1 day", "3 hours" etc. you can only choose one number and one unit. You cannot define "1 hour 20 minutes", you should say "100 minutes".

### Output

The incoming record with an additional field:

* `url` - The URL which is usable only until the end of expiry duration defined

If the request fails, then an `error` string is added instead

### Notes

* The bucket path and incoming path strings are directly concatenated. If you need a separator slash you should put it
  on the end of the bucket path or on the start of the incoming path string (but not both!).

### See Also

* S3 Get
