## S3 Put

This step puts bytes into AWS S3

### Structure
1 => 1

### Input

Each incoming record should contain bytes, a path (including filename) and a mimeType.

### Parameters

* `Bucket` - the name of the bucket information to use from System Settings AWS Integration.

* `Path Field` - the incoming string field holding the path to be appended to the bucket path.

* `MimeType Field` - the incoming string field holding the mimeType of the bytes.

### Output

The incoming record with an additional field 's3-put-info' containing:

* `region` - The region holding the bucket

* `bucket` - The bucket name

* `path` - The consolidated path (bucket path plus incoming path)

* `length` - The number of bytes stored in S3

If the request fails, then an `error` string is added instead

### Notes

* The bucket path and incoming path strings are directly concatenated. If you need a separator slash you should put it
  on the end of the bucket path or on the start of the incoming path string (but not both!).

### See Also

* S3 Delete

* S3 Get
 
* S3 List
