## Filter Contains

This step filters records based on whether a named string field contains a specified substring.
Only those records where the field exists and holds the substring are retained.

### Structure
1 => 0..1

### Input
A string field is required in the input record

### Parameters
* `Field` - the string field to be tested. 
* `Substring` - the substring to be located within the field value.

### Output
Those input records with a valid string field which contains the substring value

#### Notes
* If the string field doesn't exist or is not a string the record will be discarded

* ETL steps trim user-entered strings, so the substring cannot begin or end with whitespace

#### See Also
* Filter Ends With
* Filter Matches
* Filter Starts With
