## Decode LDIF

This step decodes an LDIF text string (usually multiple lines, separated by blank lines) 
into a record structure. For convenience, bytes (BsonBinary) is also accepted and decoded 
as if stored with UTF-8 encoding.

### Structure
1 => N

### Input
A string/binary field is required in the input record holding the LDIF data 

### Parameters
* `Field` - the string/binary field to be decoded.

* `Output` - the field to hold the decoded results, if empty the results will be added at the top level of the record

### Output
The input record with the string/binary field removed (to save RAM) and augmented with the decoded LDIF data, 
other incoming fields are passed through unchanged, unless overridden by decoded LDIF values

#### Notes
* If the field value is not a string/binary or does not exist, no change is made

* All LDIF output is retained in string format, there is no attempt to identify and convert numbers, dates etc.

#### See Also
