## Merge

This step merges records where all but one string field are the same, merging the different values of
that field into a single string value, by combining with a separator.

For example, given:

| F1 | F2 | F3 | F4 | F5 |
|----|----|----|----|----|
| A | B | C | 10 | l |
| A | B | C | 10 | m |
| A | B | C	| 10 | n |
| D | E	| F	| 0  | p |
| D | E	| F	| 0  | q |

The result of merge on Field 5 with Separator ',' is:

| F1 | F2 | F3 | F4 | F5 |
|----|----|----|----|----|
| A | B | C | 10 | l,m,n |
| D | E	| F	| 0  | p,q |


### Structure
N => M  where M <= N

### Input
None required

### Parameters
* `Field` - The field which holds the values to be merged

* `Separator` - The separator to use when combining the merged string values

### Output
The merged input records (ie. de-duplicated) with the `Field` replaced by the 
merged string values of all otherwise equal records

#### Notes
* If a particular record does not include a matching string field at all, 
it will not contribute to the merged field value, but will still be removed from the output.

#### See Also
* Split
