## Chain Call

This step can call another chain for every record received, passing that
record as the parameters to the called chain.

In this step, the name of the called chain is fixed, so each record will 
invoke the same chain. This allows reusable "sub-chains" to be created
and then called in the same way that functions are used in programming.
Calling a chain is like calling a function or subroutine - the results 
of the called chain then continue as records in the main flow.

### Structure
1 => 0..N

### Input
Each input record is passed as parameters to the called chain, which may 
extract the fields it needs. The called chain decides whether any input
fields are returned at the end of the called chain.

### Parameters
* Chain Name - The name of the chain that will be called for each 
incoming record.

### Output
For each record in, 

* if a chain name is specified and is valid, the output will be
the results of running the named chain with the input record as parameter.

* if no chain name is specified the record is passed through unchanged

* if the chain name is invalid an error is raised

#### Notes
* Use this step to avoid duplicating long chains and to provide more 
maintainable chainsets by breaking long sequences down into logical groups.


#### See Also
* Chain Call Field
* Chain to Array
