## Chain If/Else

This step invokes one of two chains, depending on an input Boolean Field. 
The behaviour is the same as Chain Call, but the choice of chain is dependent 
on each record.

### Structure
1 => 0..N

### Input
Each input record should provide Boolean Field (parameter below). 
The intput record is passed as parameters to the chosen (True/False) called chain, 
which may extract the fields it needs. The called chain decides whether any input
fields are returned at the end of the called chain. 

### Parameters
* Boolean Field - The field holding the boolean value to extract
* True Chain - The chain to call if the boolean field is true
* False Chain - The chain to call if the boolean field is false

### Output
For each record in, 

* If the Boolean Field is true, the output will be the results of running 
the named True Chain with the input record as parameter.

* If the Boolean Field is false, the output will be the results of running 
the named False Chain with the input record as parameter.

* If the Boolean Field does not match the Call If criteria (either because the field
doesn't exist, is not the right type) then the
input record is passed directly to the output.

#### Notes
* This step provides a simple conditional execution - a sub-chain can be called 
when certain criteria are satisfied. Usually the preceding steps will set up the 
boolean field ready for testing in this step, eg. a Compare field like "age > 60"
produces a boolean which can then be used to decide which chain should be called. 


#### See Also
* Chain Call

* Chain If

