## Chain On Start

This step invokes a named Chain at the very beginning of the record stream and attaches the result to every record that passes through.

For example, if you need to generate a UUID and use it across several records, generate the UUID in a Chain called On Start and every 
record that passes through will get the same UUID. If you just called the UUID step directly, you would get a different one for each record.


### Structure
1 => 1

### Input
Any record can be passed through

### Parameters

* `Chain Name` - the chain to call at the start of processing

* `JSON` - the JSON to pass as a parameter to the chain

* `Result Field` - the field to hold the result of the chain

### Output
The input record with the `Result Field` set according to the result of the called chain

#### Notes
* If the called chain produces no results, then no Result Field is added

* If the called chain produces a single record, then it will be added as the Result Field

* If the called chain produces multiple records, then the Result Field will be an Array holding those results

#### See Also
* Chain Call

