## Choose First

This step scans a series of fields in a record and stores the first one found into a result field.

A field is chosen if it exists and is not null. Given:

```
{ "second": null, "third": "hello", "fourth": "world", "notused": true }
```

with fields = first,second,third,fourth and result = out, this step will emit:

```
{ "second": null, "third": "hello", "fourth": "world", "notused": true, "result": "hello" }
```

because first does not exist and second is null. Once third is found, no others are scanned.

### Structure
1 => 1

### Input
No special requirements

### Parameters
* `Fields` - The comma-separated list of field names to choose from.

* `Result` - The field to hold the chosen (first non-null) field found.
 
### Output
The original record is passed through, with the new result field, if a non-null field is found. 
If nothing is found, then the original record is passed through unchanged.

#### Notes

This step is useful if you have to cleanse or control a variety of inputs. 
For example, the data used to arrive like this:

```
{ "name": "X", "adress": "Y" }
```

and then someone realised that address was spelt wrong. 

Using this step with fields = "address, adress" and result = "address", then the logic can accept both the correct
spelling and the old incorrect spelling, preferring the new spelling in the unlikely case that both are provided.
The rest of the logic can now use the proper spelling throughout as this step corrects that mistake.

#### See Also
