## Collect to Array

This step collects a named field or fields from each input record and upon completion emits a single record
with an array holding all the values collected. The array holds the items in the same order they were processed,
duplicates are not removed. Missing values (ie. field not present) are removed, so there won't be any nulls in 
the result.

The behaviour is different for single field and multiple fields.

For single fields, an array of values is produced. This array contains just the values, not name: value.

For multiple fields, an array of records is produced, with each collected field retained within it. Because
there are multiple fields, the name: value pair is retained to distinguish between them.

### Structure
N => 1

### Input
Any record can be passed through

### Parameters

* `Fields` - the list of field names to be collected, separated by commas

* `Result Field` - the field to hold the array result

### Output
The input record with the `Result Field` set to an array of collected values or records

#### Notes
* When the field list contains more than one name, a document will be added to the output array
as long as at least one named field exists in the input record. There will be no document added if none of the 
collected fields is present.

* When the field list contains one name, a value will only be added to the output array if the incoming record
has a value for that field. 

* In both cases, an explicit null value *is* a value and will be included. Only absence of the field 
can result in absence in the output.

#### See Also
* None

