## Copy Records (Field)

This step duplicates the incoming records based on a count derived from a field.
A unique field called `copy` is added to each record. The original is numbered 0
with all other duplicates adding one. 

### Structure
1 => N

### Input
The incoming record should have an integer field to be used as the count.

### Parameters
* `Field` - the integer field (Int32) which determines the number of copies to make

### Output
The input record duplicated multiple times each with a unique field set:

* `copy` - 0 for the original and incremented for each copy.

#### Notes
* The number of copies is in addition to the original. So Count=2 will output three 
records, the original (copy=0) plus the two copies (copy=1, copy=2).

* If the chosen `Field` is not an integer or does not exist, the original 
record is passed through unchanged.

* Only an Int32 value is allowed - check you don't have Int64 or Double.

#### See Also
* Copy Records
