## Do Chain While

This step will call another chain for every record received, passing that
record as the parameters to the called chain.

The called chain is expected to provide a single record in output, any additional ones 
will be not be read. If no record is output, this step will terminate, as there are no records 
to pass to subsequent steps. 

When a record is received from the called chain, a `Test Field` will be examined. 
The value of this field is expected to be a boolean. If the value is true, the chain will be called again, 
with the output record merged over the original input record. This allows results from one loop to be made available
to the next iteration. This process will continue until the called chain meets the termination rules.

Termination occurs when the called chain: 

* produces no records out
 
* produces a single record out with `Test Field` not set to boolean true
 
This means processing will terminate if `Test Field` is false, any other type or missing entirely. 

Upon termination, if a record was produced by the called chain, it will be passed to the next step.

### Structure
1 => 0..1

### Input
Each input record is passed as parameters to the called chain.

### Parameters

* `Chain Name` - The name of the chain that will be called (perhaps many times) for each incoming record.

* `Test Field` - The name of the test field used to terminate the while loop

* `Max Loops` - The maximum number of times the chain can be looped for each incoming record

### Output
The final record emitted from the called chain which terminated the loop. If there isn't one, then nothing is 
output and the chain will terminate as there is no input for the next step.

#### Notes

* Be very careful about termination conditions as while loops like this can easily lead to endless loops.
  There is a max loop limit to prevent this step from running forever, but it could still loop for a long time,
  given that this is per input record. With Max Loops 1000 (the default) and only 1000 records we have a million chains executed.


#### See Also
* Chain Call
* Chain to Array
