## Function Call

This step emulates a function call by calling another chain which has a defined Function Signature.

Unlike Chain Call, where an entire record is passed in, and the resulting record(s) become the output, 
the Function Call only passes in the parameters identified in the Function Signature, renaming them 
according to the function signature and takes out the result fields in the same manner.

This step is often more convenient for reusable functions, because the values passed in are renamed, and the 
results returned are renamed also, saving shuffling of fields before and after a Chain Call to ensure everything
matches what the Chain Call expects and produces.

### Structure
1 => 1 (when Repeat Output is false) 0 => N (when Repeat Output is true)

### Input
The fields listed in the Call step will be extracted and provided to the called chain. 
Any missing fields will be passed as Nulls.

### Parameters
* `Function Name` - The name of the chain that will be called for each incoming record. Only chains which 
  include a Function Signature step are eligible. (The signature defines the parameters and returns.)

* `Repeat Output` - The called chain might return 0..N records. If Repeat Output is false, then the only the 
  first record output will be used - the rest will be ignored. If no record is output, then an empty one is used.
  Alternatively, if Repeat Output is true, the incoming record will be cloned once for each record produced by the 
  called chain - this could be zero, one or N records.

* `In Fields` - varies based on the names of parameters defined in the Function Signature
 
* `Out Fields` - varies based on the names of returns defined in the Function Signature

### Output

See the definition of Repeat Output - incoming records are passed through with the returns from the function call merged in.
Any missing return values will be passed as Nulls.

#### Notes
 
* A function (Function Signature) may be defined with up to five parameters and up to five returns. 

#### See Also

* Function Signature

* Chain Call
