## Function Signature

This step defines the expected parameters and returns from a chain, similar to a function signature in a programming language.

This step does not perform any action, it is a "marker" step which is used to identify chains which are intended
for easy reuse.  The parameters and returns defined here will be used to construct the step dialog for calling this 
chain in Function Call.

It is recommended (but not required) that this step be placed at the top of the chain, in the same way a function signature is
typically defined at the start.

### Structure
1 => 1 (unchanged)

### Input
There are no input requirements

### Parameters
* `Parameters` - A list of parameters that the caller should supply to this chain. These may be specified as a comma-separated list,
  or one per line. The maximum number is five.

* `Returns` - A list of returns that the caller will receive upon completion of this chain. These may be specified as a comma-separated list,
  or one per line. The maximum number is five.

### Output
This step does nothing, so the output is the same as the input. 

#### Notes
 
* A Function Signature may be defined with up to five parameters and up to five returns.

* If a chain includes more than one Function Signature, only the first one will be used. (It is recommended to make the
  Function Signature the first step.)

#### See Also

* Function Call

* Chain Call
