## Change RegEx Field Types

This step converts multiple field values to other types. Rather than enumerate all field names, they are selected by a regular expression.

The available target types are: BinaryUTF8, Boolean, DateTime, Decimal128, Double, Int32, Int64, String

### Structure
1 => 1

### Input
There are no constraints on input - conversion fields need not exist.

### Parameters
* `Convert Field RegEx` - The regular expression that identifies the names of the fields to convert from

* `To` - The name of the type to convert the value(s) to

### Output
The input record with fields converted, where possible


#### Notes
* Type conversion will only be successful with appropriate input: `"123"` to Double will give `123.0`, but `"ABC"` to Double will remain `"ABC"`.

* BinaryUTF8 is the result of converting the type to a String (if it isn't already) and then encoding that String as a UTF-8 byte array. 
The primary use of this is for outputting strings to a file, without any additional structure (eg. wrapped as JSON or formatted as CSV).

#### See Also
* Change Field Type
* Change Field Types

