## Restructure

This step restructures a record, potentially into multiple output records.

For each incoming record, the new structure is output. The new structure may be a single record, perhaps with some extra
fields added, or names changed, like this:

```
{ "result": "$original", "unchanged": "$unchanged", "another": true }
```

The above example renames the "original" field to "result", leaves the field called "unchanged" as before, and adds a new
field called "another". Note that any other incoming fields will be discarded.

It is also possible to have an array for the new structure:
```
[
  { "result": "$original", "unchanged": "$unchanged", "another": true },
  { "unchanged": "$unchanged", "different": 123 }
]
```

The above example produces two output records for each incoming record, with both records having the "unchanged" field.

As a special case, a value of just "$" means the root of the document, so it is possible to move the incoming document
down to a child location:

```
{ "received": "$" }
```

given the input:

```
{ "a": "Hello" }
```

will produce:

```
{ "received": { "a": "Hello" } }
```


### Structure
1 => N

### Input
No special requirements

### Parameters
* `New Structure` - The new structure to output for each incoming record, with values starting with "$" substituted
  from the incoming record.

### Output
The new structure built from each incoming record.

#### Notes
* Consider using Add Fields if you only want to add and not discard existing content, 
  as this will preserve any incoming fields that might be added in future. Restructure will discard anything not 
  defined in the new structure.  
  
* Defining a substitution like "newName": "$oldName" does not mean that oldName is necessarily a string field - the field
value can be of any type.

#### See Also
* Rename

* Add Fields
