## Take First Records

This step takes a fixed number of records from upstream. It is useful to limit the 
number of records being processed while testing logic - eg. take 100 records to work with,
instead of the million available from upstream.

### Structure
N => 0..Count

### Input
No input requuirements

### Parameters
* Count - The maximum number of records to pass through.

### Output
No more than `Count` records will be output. Of course, there may be less than Count, 
if the upstream steps complete before supplying that many.

#### Notes
* Useful to limit test data while revising logic - you can always disable the step later when
you need to process the full data.

* Useful to take a limited number of time-series data - eg. a sensor providing records 
once every five seconds, stop after 12 records to have one minute's worth of data.

* Upstream steps will ideally use back-pressure - so limiting and stopping the upstream steps
from doing more work than requested. Take will not ask for more than `Count` records 
from the upstream steps.

#### See Also

* Take Last Records

* Drop Records
