## Add/Subtract Millis

This step allows the addition or subtraction of milliseconds, with
convenient helpers for hours, minutes and seconds.  Use this step
to adjust timestamps. You can specify values for any combination of values, 
eg. add 5 hours and 3 seconds.

### Structure
1 => 1

### Input
A field containing a timestamp

### Parameters
* `From Field` - The field holding the timestamp

* `Operation` - Either Add or Subtract

* `Hours` - The number of hours to adjust

* `Minutes` - The number of minutes to adjust

* `Seconds` - The number of seconds to adjust

* `Milliseconds` - The number of milliseconds to adjust

* `To Field` - The result field (same as From if blank) 

### Output
The input record with fields set:

* `<To Field>` - The resulting timestamp after addition/subtraction

#### Notes
* This step does not support intervals of days, months or years, because
these are not fixed durations - they vary based on where and when. Many
countries support daylight savings time, so some days have 23 hours and 
others 25. 

* Without knowledge of the time zone in operation - which is not part of 
the timestamp value - it is not possible to guarantee correct results for
offsets of days, months or years. Depending on context, you may use 24 hours 
as an approximation of a day.  

#### See Also
* LocalExtract - extracts individual fields in the local time zone, which can
then be manipulated
* ZoneExtract - extracts individual fields in a specified time zone

