## ISO Date Range

This step will validate that a field contains an ISO date string and that the date is
in the correct format and within the allowed range.  Use this step when the presented date format
is not ISO, but the data is stored internally as ISO.

### Structure
1 => 1

### Input
* A record with a string field holding an ISO date value.

### Parameters
* `ISO Date Field` - The string field holding the ISO date for testing
* `Minimum (yyyy-MM-dd)` - The earliest allowed date (in ISO format)
* `Maximum (yyyy-MM-dd)` - The latest allowed date (in ISO format)
* `Local Format` - The format of the date to show in validation messages

### Output
If the string field holds a valid date, the record is passed through unchanged.

If the string field cannot be parsed as an ISO date, a `validationIssue` will be added.

If the string field can be parsed as an ISO date but is outside the allowed range, a `validationIssue` will be added.

#### Notes

* This variant is used when the display says: 20/08/2021, but internally we store 2021-08-20. The validationIssues
needs to contain text in the dd/MM/yyyy format to be useful to the user. Therefore if the date is outside the allowed
range, the message is formatted so that min...max are displayed in Local Format, not ISO. 
  
* If the date is not actually an ISO string, we cannot convert it into a Local Format for presentation, so we just 
  have to show what we received. 

#### See Also
* Date Range
