## Secure Web Store Field Writer

This step takes a records with a byte array named `bytes` along with a file location
and writes the bytes to that location.

SecureWebStore is only accessible by the current user, unlike WebStore which is accessible by all authenticated users.

### Structure

1 => 1

### Inputs

`bytes` to be written to the file and a field (named by parameter `filepath`) containing the target file location

### Parameters

* `File Path` - The location of the file to be written
* `Expiry ` - Length of time in milliseconds after which the file will not be available.

### Output

* `url` - Web Store URL as /secure-web-store/..., for example "secure-web-store/083229c7-05d7-4f7e-9776-d81f3fb091e1/report.pdf"

* `expiryAt` - Time the file will expires at

* `count` - The number of files created

* `length` - The total length of the file

* `_error` - This string field will be added if the operation fails, with details of the issue


On success, the record is passed through unchanged. As a side-effect the bytes have been written to SecureWebStore.

#### Notes

* If two records have the same file location, the bytes from the second record will overwrite those of the first.
