## Web Store Writer

This step takes a bytes field from each incoming record and appends them all to create a file in WebStore

### Structure

N => 1

### Inputs

Every record must contain `bytes`

### Parameters

* `File Path` - The path and name where the file is to be written to. Use uuid as part of the path to ensure unique identity of the file. An example as "083229c7-05d7-4f7e-9776-d81f3fb091e1/report.pdf"
* `Expiry` - Length of time in milliseconds after which the file will not be available.  

### Output

* `url` - Web Store URL as /web-store/..., for example "web-store/083229c7-05d7-4f7e-9776-d81f3fb091e1/report.pdf"

* `expiryAt` - Time the file will expire at 
  
* `count` - The number of files created

* `length` - The total length of the file

* `_error` - This string field will be added if the operation fails, with details of the issue

#### Notes

* Multiple records are appended into a single output file. However, the file is emptied before the first record
  is added, so this step does not append to any pre-existing content.
  
* Note that there is no user/role access control - any authenticated user with the correct URL can see the file. 
  Hence you should use a uuid as shown to avoid URL guessing. Non-authenticated users cannot see anything.


