## Create Instance

This step creates a Workflow instance set to the first usable state

### Structure
1 => 1

### Input
The incoming record will be passed to the workflow create process as the 
parameters of the first transition. This means that the ETL chain (if there is one) on that transition
will receive the parameters as the content of elxEvent. So if the incoming record is 

```
{ "demo": { "value": 123 } }
```

Then the ETL chain will receive:

```
{
  "_id": "<workflow instance id>",
  "elxEvent": { "demo": { "value": 123 } },
  "workflowId": "<workflow id>",
  "elxPublic": {},
  "elxPrivate": {},
  <other housekeeping fields>
}
```
so that you can use the parameters inside elxEvent to construct the initial values of elxPublic/elxPrivate.

### Parameters
* `workflow` - A workflow

### Output
The workflow instance, a record which will contain a workflowId, elxPrivate, elxPublic and elxHistory
along with other internal housekeeping fields.


#### See Also

* Create Instance Field