## Duplicate Workflow

This step duplicates a Workflow Template, with a new name, and optionally a new database/collection.
This is useful because a Workflow can only target a single collection and sometimes we wish to have common
workflow structures but writing into separate locations.

Note that any change to the original template is not replicated in any duplicates. To help with this, you can consider running
`Duplicate Workflow` again. If the target name already exists, then it will be overwritten from the source and will preserve
the existing target _id, so that it doesn't break any other uses.  Of course this means you need to be very careful that you 
don't overwrite the wrong target. For this reason, there is an `Allow Overwrite` you must enable before overwrites can happen.

### Structure
1 => 1

### Input
The incoming record must contain both an existing workflow name along with the desired new name. You can
also pass in new database and collection names. If not supplied, the originals will be retained.

### Parameters
* `Workflow Field` - The incoming field holding the name of the workflow to duplicate

* `New Name Field` - the incoming field holding the new name for the duplicate 

* `New Database Field` - the incoming field holding the new database for the duplicate - leave this blank for unchanged
 
* `New Collection Field` - the incoming field holding the new collection for the duplicate - leave this blank for unchanged

* `Allow Overwrite` - this step will only overwrite an existing name if this option is ticked, otherwise it will indicate an error.

### Output

The original record will be passed through with the addition of a new field `newId` which holds the duplicated workflow Id.
Note that in the case of overwrite, this will be a pre-existing, rather than new, id.

#### See Also

