## Get Current State

This step extracts the current state information from a workflow instance, using "friendly" names rather than internal ids.

### Structure
1 => 1

### Input
* A record holding a workflow id and a workflow instance id

### Parameters
* `Workflow Id Field` - a string field on the incoming record which holds the id of the workflow
 
* `Instance Id Field` - a string field on the incoming record which holds the workflow instance id that should be examined

### Output
The input record is passed through with the addition of an `elxState` field which holds key/value pairs of state machine names and their current state.

For example, with the standard default state machine called "Main":

```
{ ...  "elxState": { "Main": "Running" } ... } 
```

or if there are two concurrent state machines, First and Second:

```
{ ...  "elxState": { "First": "Page1", "Second": "Approved" } ... } 
```

### Notes

* If either id is not found or does not match a valid record, no elxState is added and a warning is written to the JobLog

#### See Also

* Lookup States
 