## Lookup States

This step lists the stateMachine ids and names as well as the state ids and names within them.
The step is useful for joining with workflow instances where only the ids are held for efficiency reasons 

### Structure
1 => N

### Input
* A record holding a workflow id

### Parameters
* `Workflow Id Field` - a string field on the incoming record which holds the workflow id that should be examined

### Output
The input record is passed through multiple times, annotated with the following fields:

* stateMachineId - the id of the state machine

* stateMachineName - the name of the state machine (the default is 'Main')

* stateId - the id of a state within the state machine

* statelabel - the label of the state

In other words, if a workflow has two state machines, one with three states (Start->Running->Stop) and the other has
four states (Start->Page1->Page2->Stop), then the output would be 3+4 = 7 records.

### Notes

* If the workflowId string field is not found there is no output and a warning is written to the JobLog

* If the workflowId string does not match any existing workflow id, there is no output and a warning is written to the JobLog

#### See Also

* Get Current State