## Xlsx File Writer

This step converts incoming records into a an XLSX file on disk. 

This step is useful if you want to simply produce an XLSX file. 
If you want to further process the bytes, then consider the Xlsx Writer
which retains the bytes in the ETL chain. 

### Structure
N => 1

### Input
The records received will be converted into rows in an XLSX spreadsheet

### Parameters
* `Sheet` - the name of the Sheet in the generated spreadsheet

* `Write Header` - if true, include the column names in the first row

* `Columns` - the names of fields in the record that should be converted to cells. These should
be written one per line in the order that they should appear in the spreadsheet. You can access child
objects directly, eg. via parent.child syntax. Note that the column header will use the name here, so
restructuring prior to this step may be useful. 

* `File` - the file into which the XLSX spreadsheet should be written.

### Output
A single record containing:

* `bytes` - The byte array holding the XLSX spreadsheet

* `mimeType` - The mime-type. Always "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"

* `rowCount` - The number of data rows in the spreadsheet (ignoring the header row)

#### Notes
* If a particular record does not include a particular column, that cell will be left blank

* Xlsx Writer uses the File Writer configuration - which means XLSX files can only be written to 
a set of pre-configured directories (to prevent accidental/deliberate overwrites of sensitive data). 
By default this is ./data/out. Attempting to write elsewhere will result in a job error: 
"Write disallowed by config".

#### See Also
* Xlsx Writer
