## Xlsx Writer

This step converts incoming records into a byte array which represents an XLSX file. 

This step is useful if you want to process the bytes directly, for example to transmit, to attach, 
to save to database etc. If you want to save the contents to disk, then prefer the Xlsx File Writer
which does this in a single step. 

### Structure
N => 1

### Input
The records received will be converted into rows in an XLSX spreadsheet

### Parameters
* `Sheet` - the name of the Sheet in the generated spreadsheet

* `Write Header` - if true, include the column names in the first row

* `Columns` - the names of fields in the record that should be converted to cells. These should
be written one per line in the order that they should appear in the spreadsheet. You can access child
objects directly, eg. via parent.child syntax. Note that the column header will use the name here, so
restructuring prior to this step may be useful. 

### Output
A single record containing:

* `bytes` - The byte array holding the XLSX spreadsheet

* `mimeType` - The mime-type. Always "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"

* `rowCount` - The number of data rows in the spreadsheet (ignoring the header row)

#### Notes
* If a particular record does not include a particular column, that cell will be left blank

* As an ETL record can hold no more than approx 16MB of data, you must use Xlsx File Writer if your 
spreadsheet is likely to be larger. The byte array `bytes` could grow to exceed the maximum record size
when working with huge numbers of records - write to disk to reduce memory consumption.

#### See Also
* Xlsx File Writer
