/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.pivot;

import ambience.CommonLogging;
import com.elixirtech.coredata.Data;
import com.elixirtech.coredata.JsonToString$;
import com.elixirtech.pivot.ConstraintTree;
import com.elixirtech.pivot.ConstraintTreeNode;
import com.elixirtech.pivot.Constraints;
import com.elixirtech.pivot.CubeTable$Cell$;
import com.elixirtech.pivot.CubeTable$CellRequest$;
import com.elixirtech.pivot.CubeTable$Spans$;
import com.elixirtech.pivot.CubeTableOptions;
import com.elixirtech.pivot.Measure;
import com.elixirtech.pivot.Measure$Calculation$;
import com.elixirtech.pivot.Operation;
import com.elixirtech.pivot.Record;
import com.elixirtech.pivot.Tuple;
import com.elixirtech.pivot.Tuple$;
import com.elixirtech.pivot.TupleSpace;
import com.elixirtech.vdom.mutable.VElement;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class CubeTable
extends CommonLogging {
    private final TupleSpace tupleSpace;
    private final List rows;
    private final List cols;
    private final List measures;
    private final CubeTableOptions options;
    private final ConstraintTree rowTree;
    private final ConstraintTree colTree;

    public CubeTable(TupleSpace tupleSpace, List<Data.Field> rows, List<Data.Field> cols, List<Measure> measures, CubeTableOptions options) {
        this.tupleSpace = tupleSpace;
        this.rows = rows;
        this.cols = cols;
        this.measures = measures;
        this.options = options;
        this.rowTree = tupleSpace.buildTree(rows, options.rows().showRowTotals());
        if (options.rows().enforceRowHierarchy()) {
            this.rowTree().root().enforceHierarchy(tupleSpace.rangeHolder().dataset());
        }
        this.colTree = tupleSpace.buildTree(cols, options.columns().showColumnTotals());
        if (options.columns().enforceColumnHierarchy()) {
            this.colTree().root().enforceHierarchy(tupleSpace.rangeHolder().dataset());
        }
        this.removeColumn(this.rowTree());
        this.rowTree().root().expand();
        this.colTree().root().expand();
    }

    public TupleSpace tupleSpace() {
        return this.tupleSpace;
    }

    public List<Data.Field> rows() {
        return this.rows;
    }

    public List<Data.Field> cols() {
        return this.cols;
    }

    public List<Measure> measures() {
        return this.measures;
    }

    public CubeTableOptions options() {
        return this.options;
    }

    public ConstraintTree rowTree() {
        return this.rowTree;
    }

    public ConstraintTree colTree() {
        return this.colTree;
    }

    public void fillData(List<Cell> cells) {
        cells.foreach((Function1)(JProcedure1 & Serializable)model -> this.fill((Cell)model));
    }

    public void fill(Cell model) {
        boolean isColTotal;
        boolean isRowTotal = model.rowNode().children().nonEmpty();
        boolean bl = isColTotal = model.colNode().children().nonEmpty() && model.colNode().isExpanded();
        if (isRowTotal || isColTotal) {
            model.td().addClass("cell-total");
        }
        Constraints rowConstraints = model.rowNode().constraints();
        Constraints colConstraints = model.colNode().constraints();
        Constraints constraints = rowConstraints.withDefault(colConstraints);
        Constraints constraints2 = colConstraints.withDefault(rowConstraints);
        Constraints constraints3 = constraints;
        Constraints constraints4 = constraints2;
        if (!(constraints3 != null ? !constraints3.equals(constraints4) : constraints4 != null)) {
            Option<Tuple> option = this.getTuple(model, constraints);
            if (option instanceof Some) {
                Tuple tuple = (Tuple)((Some)option).value();
                String string = model.measure().calculation();
                String string2 = Measure$Calculation$.MODULE$.Normal();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.fillCell(model.td(), tuple.value(), model.measure());
                    v3 = BoxedUnit.UNIT;
                } else {
                    String string4 = Measure$Calculation$.MODULE$.RatioOfColumn();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        v3 = this.getSupportingTuple(CubeTable$CellRequest$.MODULE$.apply(model, colConstraints)).flatMap((Function1 & Serializable)totalTuple -> tuple.value().asNumber().map((Function1 & Serializable)_$1 -> _$1.toDouble()).flatMap((Function1 & Serializable)value -> this.fill$$anonfun$1$$anonfun$2((Tuple)totalTuple, model, BoxesRunTime.unboxToDouble((Object)value))));
                    } else {
                        String string6 = Measure$Calculation$.MODULE$.RatioOfRow();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            v3 = this.getSupportingTuple(CubeTable$CellRequest$.MODULE$.apply(model, rowConstraints)).flatMap((Function1 & Serializable)totalTuple -> tuple.value().asNumber().map((Function1 & Serializable)_$3 -> _$3.toDouble()).flatMap((Function1 & Serializable)value -> this.fill$$anonfun$2$$anonfun$2((Tuple)totalTuple, model, BoxesRunTime.unboxToDouble((Object)value))));
                        } else {
                            String x = string;
                            this.log().warn(() -> CubeTable.fill$$anonfun$3(x), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("com.elixirtech.pivot.CubeTable.fill"));
                            this.fillCell(model.td(), tuple.value(), model.measure());
                            v3 = BoxedUnit.UNIT;
                        }
                    }
                }
            } else if (None$.MODULE$.equals(option)) {
                v3 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            model.td().addClass("pivot-value-cell").attr("data-constraint", this.buildDataConstraint(constraints));
            return;
        }
    }

    public String buildDataConstraint(Constraints c2) {
        String plain = Json$.MODULE$.obj((Seq)c2.values().map((Function1 & Serializable)c -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)c.field().name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)c.value());
        })).noSpaces();
        return plain.replace("&", "&amp;").replace("<", "&lt;").replace("\"", "&quot;");
    }

    public Option<Tuple> getTuple(Cell cell, Constraints constraints) {
        Option<Tuple> option = this.tupleSpace().getTuple(constraints.$plus(cell.measure().constraint()));
        if (option instanceof Some) {
            Tuple t = (Tuple)((Some)option).value();
            return Some$.MODULE$.apply((Object)t);
        }
        if (None$.MODULE$.equals(option)) {
            return this.getSupportingTuple(CubeTable$CellRequest$.MODULE$.apply(cell, constraints));
        }
        throw new MatchError(option);
    }

    public Option<Tuple> getTuple(Constraints constraints, Measure measure) {
        Option<Tuple> option = this.tupleSpace().getTuple(constraints.$plus(measure.constraint()));
        if (option instanceof Some) {
            Tuple t = (Tuple)((Some)option).value();
            return Some$.MODULE$.apply((Object)t);
        }
        if (None$.MODULE$.equals(option)) {
            return this.getSupportingTuple(constraints, measure);
        }
        throw new MatchError(option);
    }

    public Option<Tuple> getSupportingTuple(CellRequest cr) {
        Seq<Record> data = this.tupleSpace().rangeHolder().dataset().data();
        Operation.Builder builder = cr.cell().measure().operation().builder(cr.cell().measure().field());
        Seq chosen = (Seq)data.filter((Function1 & Serializable)rec -> this.withConstraint((Record)rec, cr.constraints()));
        chosen.foreach((Function1)(JProcedure1 & Serializable)rec -> builder.add(rec.measures()));
        Json json = builder.result();
        return Some$.MODULE$.apply((Object)Tuple$.MODULE$.apply(cr.constraints(), json));
    }

    public Option<Tuple> getSupportingTuple(Constraints constraints, Measure measure) {
        Seq<Record> data = this.tupleSpace().rangeHolder().dataset().data();
        Operation.Builder builder = measure.operation().builder(measure.field());
        Seq chosen = (Seq)data.filter((Function1 & Serializable)rec -> this.withConstraint((Record)rec, constraints));
        chosen.foreach((Function1)(JProcedure1 & Serializable)rec -> builder.add(rec.measures()));
        Json json = builder.result();
        return Some$.MODULE$.apply((Object)Tuple$.MODULE$.apply(constraints, json));
    }

    public boolean withConstraint(Record record, Constraints constraints) {
        return constraints.values().forall((Function1 & Serializable)c -> c.matches(record));
    }

    public Option<BoxedUnit> logInfo(String msg) {
        Predef$.MODULE$.println((Object)msg);
        return Some$.MODULE$.apply((Object)BoxedUnit.UNIT);
    }

    public void fillCell(VElement td, Json value, Measure measure) {
        td.text((String)measure.format().apply((Object)value));
        td.attr("data-value", value.noSpaces());
        measure.raw().foreach((Function1 & Serializable)raw -> td.attr("elx-format", raw.noSpaces()));
        td.addClass(measure.alignment().cls());
    }

    public String asString(Json v, String string) {
        Json json = v;
        Json json2 = Json$.MODULE$.Null();
        if (!(json != null ? !json.equals(json2) : json2 != null)) {
            return string;
        }
        return (String)JsonToString$.MODULE$.apply(v).getOrElse(CubeTable::asString$$anonfun$1);
    }

    public void requestTuples(List<CellRequest> queue) {
    }

    public void removeColumn(ConstraintTree tree) {
    }

    private final /* synthetic */ Option fill$$anonfun$1$$anonfun$2$$anonfun$2(double value$1, Cell model$3, double total) {
        return Json$.MODULE$.fromDouble(value$1 / total).flatMap((Function1 & Serializable)percent -> {
            this.fillCell(model$3.td(), (Json)percent, model$3.measure());
            return Some$.MODULE$.apply((Object)BoxedUnit.UNIT).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    private final /* synthetic */ Option fill$$anonfun$1$$anonfun$2(Tuple totalTuple$1, Cell model$2, double value) {
        return totalTuple$1.value().asNumber().map((Function1 & Serializable)_$2 -> _$2.toDouble()).flatMap((Function1 & Serializable)total -> this.fill$$anonfun$1$$anonfun$2$$anonfun$2(value, model$2, BoxesRunTime.unboxToDouble((Object)total)));
    }

    private static final /* synthetic */ Option fill$$anonfun$2$$anonfun$2$$anonfun$2(double x) {
        if (x == 0.0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x));
    }

    private final /* synthetic */ Option fill$$anonfun$2$$anonfun$2$$anonfun$3(double value$2, Cell model$7, double total) {
        return Json$.MODULE$.fromDouble(value$2 / total).flatMap((Function1 & Serializable)percent -> {
            this.fillCell(model$7.td(), (Json)percent, model$7.measure());
            return Some$.MODULE$.apply((Object)BoxedUnit.UNIT).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    private final /* synthetic */ Option fill$$anonfun$2$$anonfun$2(Tuple totalTuple$2, Cell model$6, double value) {
        return totalTuple$2.value().asNumber().map((Function1 & Serializable)_$4 -> _$4.toDouble()).flatMap((Function1 & Serializable)x -> CubeTable.fill$$anonfun$2$$anonfun$2$$anonfun$2(BoxesRunTime.unboxToDouble((Object)x))).flatMap((Function1 & Serializable)total -> this.fill$$anonfun$2$$anonfun$2$$anonfun$3(value, model$6, BoxesRunTime.unboxToDouble((Object)total)));
    }

    private static final Object fill$$anonfun$3(String x$1) {
        return "Unexpected calculation: " + x$1;
    }

    private static final String asString$$anonfun$1() {
        return "";
    }

    public static class Cell
    implements Product,
    Serializable {
        private final ConstraintTreeNode rowNode;
        private final ConstraintTreeNode colNode;
        private final Measure measure;
        private final VElement td;

        public static Cell apply(ConstraintTreeNode constraintTreeNode, ConstraintTreeNode constraintTreeNode2, Measure measure, VElement vElement) {
            return CubeTable$Cell$.MODULE$.apply(constraintTreeNode, constraintTreeNode2, measure, vElement);
        }

        public static Cell fromProduct(Product product) {
            return CubeTable$Cell$.MODULE$.fromProduct(product);
        }

        public static Cell unapply(Cell cell) {
            return CubeTable$Cell$.MODULE$.unapply(cell);
        }

        public Cell(ConstraintTreeNode rowNode, ConstraintTreeNode colNode, Measure measure, VElement td) {
            this.rowNode = rowNode;
            this.colNode = colNode;
            this.measure = measure;
            this.td = td;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cell)) return false;
            Cell cell = (Cell)object;
            ConstraintTreeNode constraintTreeNode = this.rowNode();
            ConstraintTreeNode constraintTreeNode2 = cell.rowNode();
            if (constraintTreeNode == null) {
                if (constraintTreeNode2 != null) {
                    return false;
                }
            } else if (!((Object)constraintTreeNode).equals(constraintTreeNode2)) return false;
            ConstraintTreeNode constraintTreeNode3 = this.colNode();
            ConstraintTreeNode constraintTreeNode4 = cell.colNode();
            if (constraintTreeNode3 == null) {
                if (constraintTreeNode4 != null) {
                    return false;
                }
            } else if (!((Object)constraintTreeNode3).equals(constraintTreeNode4)) return false;
            Measure measure = this.measure();
            Measure measure2 = cell.measure();
            if (measure == null) {
                if (measure2 != null) {
                    return false;
                }
            } else if (!((Object)measure).equals(measure2)) return false;
            VElement vElement = this.td();
            VElement vElement2 = cell.td();
            if (vElement == null) {
                if (vElement2 != null) {
                    return false;
                }
            } else if (!vElement.equals(vElement2)) return false;
            if (!cell.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Cell;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Cell";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "rowNode";
                }
                case 1: {
                    return "colNode";
                }
                case 2: {
                    return "measure";
                }
                case 3: {
                    return "td";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ConstraintTreeNode rowNode() {
            return this.rowNode;
        }

        public ConstraintTreeNode colNode() {
            return this.colNode;
        }

        public Measure measure() {
            return this.measure;
        }

        public VElement td() {
            return this.td;
        }

        public Cell copy(ConstraintTreeNode rowNode, ConstraintTreeNode colNode, Measure measure, VElement td) {
            return new Cell(rowNode, colNode, measure, td);
        }

        public ConstraintTreeNode copy$default$1() {
            return this.rowNode();
        }

        public ConstraintTreeNode copy$default$2() {
            return this.colNode();
        }

        public Measure copy$default$3() {
            return this.measure();
        }

        public VElement copy$default$4() {
            return this.td();
        }

        public ConstraintTreeNode _1() {
            return this.rowNode();
        }

        public ConstraintTreeNode _2() {
            return this.colNode();
        }

        public Measure _3() {
            return this.measure();
        }

        public VElement _4() {
            return this.td();
        }
    }

    public static class CellRequest
    implements Product,
    Serializable {
        private final Cell cell;
        private final Constraints constraints;

        public static CellRequest apply(Cell cell, Constraints constraints) {
            return CubeTable$CellRequest$.MODULE$.apply(cell, constraints);
        }

        public static CellRequest fromProduct(Product product) {
            return CubeTable$CellRequest$.MODULE$.fromProduct(product);
        }

        public static CellRequest unapply(CellRequest cellRequest) {
            return CubeTable$CellRequest$.MODULE$.unapply(cellRequest);
        }

        public CellRequest(Cell cell, Constraints constraints) {
            this.cell = cell;
            this.constraints = constraints;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CellRequest)) return false;
            CellRequest cellRequest = (CellRequest)object;
            Cell cell = this.cell();
            Cell cell2 = cellRequest.cell();
            if (cell == null) {
                if (cell2 != null) {
                    return false;
                }
            } else if (!((Object)cell).equals(cell2)) return false;
            Constraints constraints = this.constraints();
            Constraints constraints2 = cellRequest.constraints();
            if (constraints == null) {
                if (constraints2 != null) {
                    return false;
                }
            } else if (!constraints.equals(constraints2)) return false;
            if (!cellRequest.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CellRequest;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CellRequest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cell";
            }
            if (1 == n2) {
                return "constraints";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Cell cell() {
            return this.cell;
        }

        public Constraints constraints() {
            return this.constraints;
        }

        public CellRequest copy(Cell cell, Constraints constraints) {
            return new CellRequest(cell, constraints);
        }

        public Cell copy$default$1() {
            return this.cell();
        }

        public Constraints copy$default$2() {
            return this.constraints();
        }

        public Cell _1() {
            return this.cell();
        }

        public Constraints _2() {
            return this.constraints();
        }
    }

    public static class Spans
    implements Product,
    Serializable {
        private final int rowSpan;
        private final int colSpan;

        public static Spans apply(int n, int n2) {
            return CubeTable$Spans$.MODULE$.apply(n, n2);
        }

        public static Spans fromProduct(Product product) {
            return CubeTable$Spans$.MODULE$.fromProduct(product);
        }

        public static Spans unapply(Spans spans) {
            return CubeTable$Spans$.MODULE$.unapply(spans);
        }

        public Spans(int rowSpan, int colSpan) {
            this.rowSpan = rowSpan;
            this.colSpan = colSpan;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.rowSpan());
            n = Statics.mix((int)n, (int)this.colSpan());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Spans)) return false;
            Spans spans = (Spans)object;
            if (this.rowSpan() != spans.rowSpan()) return false;
            if (this.colSpan() != spans.colSpan()) return false;
            if (!spans.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Spans;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Spans";
        }

        public Object productElement(int n) {
            int n2;
            int n3 = n;
            if (0 == n3) {
                n2 = this._1();
            } else if (1 == n3) {
                n2 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)n2);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "rowSpan";
            }
            if (1 == n2) {
                return "colSpan";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int rowSpan() {
            return this.rowSpan;
        }

        public int colSpan() {
            return this.colSpan;
        }

        public Spans copy(int rowSpan, int colSpan) {
            return new Spans(rowSpan, colSpan);
        }

        public int copy$default$1() {
            return this.rowSpan();
        }

        public int copy$default$2() {
            return this.colSpan();
        }

        public int _1() {
            return this.rowSpan();
        }

        public int _2() {
            return this.colSpan();
        }
    }
}

