/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Applicative;
import cats.kernel.Eq;
import io.circe.ACursor$;
import io.circe.CursorOp;
import io.circe.CursorOp$DeleteGoParent$;
import io.circe.CursorOp$DownArray$;
import io.circe.CursorOp$DownField$;
import io.circe.CursorOp$DownN$;
import io.circe.CursorOp$Field$;
import io.circe.CursorOp$MoveLeft$;
import io.circe.CursorOp$MoveRight$;
import io.circe.CursorOp$MoveUp$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.PathToRoot;
import io.circe.PathToRoot$;
import io.circe.PathToRoot$PathElem$ArrayIndex$;
import io.circe.PathToRoot$PathElem$ObjectKey$;
import io.circe.cursor.ArrayCursor;
import io.circe.cursor.ObjectCursor;
import io.circe.cursor.TopCursor;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class ACursor
implements Serializable {
    private final HCursor lastCursor;
    private final CursorOp lastOp;

    public static Eq<ACursor> eqACursor() {
        return ACursor$.MODULE$.eqACursor();
    }

    public ACursor(HCursor lastCursor, CursorOp lastOp) {
        this.lastCursor = lastCursor;
        this.lastOp = lastOp;
    }

    private HCursor lastCursor() {
        return this.lastCursor;
    }

    private CursorOp lastOp() {
        return this.lastOp;
    }

    public abstract Option<Json> focus();

    public final List<CursorOp> history() {
        Builder builder = package$.MODULE$.List().newBuilder();
        for (ACursor next = this; next != null; next = next.lastCursor()) {
            if (next.lastOp() == null) continue;
            builder.$plus$eq((Object)next.lastOp());
        }
        return (List)builder.result();
    }

    public abstract boolean succeeded();

    public final boolean failed() {
        return !this.succeeded();
    }

    public abstract Option<HCursor> success();

    public abstract Option<Json> top();

    public HCursor root() {
        return null;
    }

    public abstract ACursor withFocus(Function1<Json, Json> var1);

    public abstract <F> Object withFocusM(Function1<Json, Object> var1, Applicative<F> var2);

    public final ACursor set(Json j) {
        return this.withFocus((Function1<Json, Json>)(Function1 & Serializable)_$2 -> j);
    }

    public abstract Option<Iterable<Json>> values();

    public Option<Object> index() {
        return None$.MODULE$;
    }

    public abstract Option<Iterable<String>> keys();

    public Option<String> key() {
        return None$.MODULE$;
    }

    public abstract ACursor delete();

    public abstract ACursor up();

    public abstract ACursor left();

    public abstract ACursor right();

    public abstract ACursor downArray();

    public abstract ACursor downN(int var1);

    public abstract ACursor field(String var1);

    public abstract ACursor downField(String var1);

    public final ACursor downFields(String k, Seq<String> ks) {
        return (ACursor)ks.foldLeft((Object)this.downField(k), (Function2 & Serializable)(_$3, _$4) -> _$3.downField((String)_$4));
    }

    public final Vector pathToRoot() {
        return ACursor.loop$1(this, PathToRoot$.MODULE$.empty());
    }

    public final String pathString() {
        return PathToRoot$.MODULE$.toPathString(this.pathToRoot());
    }

    public final <A> Either<DecodingFailure, A> as(Decoder<A> d) {
        return d.tryDecode(this);
    }

    public final <A> Either<DecodingFailure, A> get(String k, Decoder<A> d) {
        return this.downField(k).as(d);
    }

    public final <A> Either<DecodingFailure, A> getOrElse(String k, Function0<A> fallback, Decoder<A> d) {
        Either<DecodingFailure, Option<A>> either = this.get(k, Decoder$.MODULE$.decodeOption(d));
        if (either instanceof Right) {
            Option option = (Option)((Right)either).value();
            if (option instanceof Some) {
                Object a = ((Some)option).value();
                return package$.MODULE$.Right().apply(a);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Right().apply(fallback.apply());
            }
        }
        if (either instanceof Left) {
            Left l = (Left)either;
            return l;
        }
        throw new MatchError(either);
    }

    public final ACursor replayOne(CursorOp op) {
        CursorOp cursorOp = op;
        if (CursorOp$MoveLeft$.MODULE$.equals(cursorOp)) {
            return this.left();
        }
        if (CursorOp$MoveRight$.MODULE$.equals(cursorOp)) {
            return this.right();
        }
        if (CursorOp$MoveUp$.MODULE$.equals(cursorOp)) {
            return this.up();
        }
        if (cursorOp instanceof CursorOp.Field) {
            String string;
            CursorOp.Field field = CursorOp$Field$.MODULE$.unapply((CursorOp.Field)cursorOp);
            String k = string = field._1();
            return this.field(k);
        }
        if (cursorOp instanceof CursorOp.DownField) {
            String string;
            CursorOp.DownField downField = CursorOp$DownField$.MODULE$.unapply((CursorOp.DownField)cursorOp);
            String k = string = downField._1();
            return this.downField(k);
        }
        if (CursorOp$DownArray$.MODULE$.equals(cursorOp)) {
            return this.downArray();
        }
        if (cursorOp instanceof CursorOp.DownN) {
            int n;
            CursorOp.DownN downN = CursorOp$DownN$.MODULE$.unapply((CursorOp.DownN)cursorOp);
            int n2 = n = downN._1();
            return this.downN(n2);
        }
        if (CursorOp$DeleteGoParent$.MODULE$.equals(cursorOp)) {
            return this.delete();
        }
        throw new MatchError((Object)cursorOp);
    }

    public final ACursor replay(List<CursorOp> history) {
        return (ACursor)history.foldRight((Object)this, (Function2 & Serializable)(op, c) -> c.replayOne((CursorOp)op));
    }

    private static final ACursor lastCursorParentOrLastCursor$1(ACursor cursor) {
        HCursor hCursor = cursor.lastCursor();
        if (hCursor instanceof ArrayCursor) {
            ArrayCursor lastCursor = (ArrayCursor)hCursor;
            return lastCursor.parent();
        }
        HCursor lastCursor = hCursor;
        return lastCursor;
    }

    private static final Vector loop$1(ACursor cursor, Vector acc) {
        while (cursor != null) {
            if (cursor.failed()) {
                CursorOp cursorOp = cursor.lastOp();
                if (cursorOp instanceof CursorOp.Field) {
                    String string;
                    CursorOp.Field field = CursorOp$Field$.MODULE$.unapply((CursorOp.Field)cursorOp);
                    String field2 = string = field._1();
                    ACursor aCursor = ACursor.lastCursorParentOrLastCursor$1(cursor);
                    PathToRoot.PathElem.ObjectKey objectKey = PathToRoot$PathElem$ObjectKey$.MODULE$.apply(field2);
                    Vector vector = PathToRoot$.MODULE$.$plus$colon$extension(acc, objectKey);
                    cursor = aCursor;
                    acc = vector;
                    continue;
                }
                if (cursorOp instanceof CursorOp.DownField) {
                    String string;
                    CursorOp.DownField downField = CursorOp$DownField$.MODULE$.unapply((CursorOp.DownField)cursorOp);
                    String field = string = downField._1();
                    ACursor aCursor = ACursor.lastCursorParentOrLastCursor$1(cursor);
                    PathToRoot.PathElem.ObjectKey objectKey = PathToRoot$PathElem$ObjectKey$.MODULE$.apply(field);
                    Vector vector = PathToRoot$.MODULE$.$plus$colon$extension(acc, objectKey);
                    cursor = aCursor;
                    acc = vector;
                    continue;
                }
                if (CursorOp$DownArray$.MODULE$.equals(cursorOp)) {
                    ACursor aCursor = ACursor.lastCursorParentOrLastCursor$1(cursor);
                    PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply(0);
                    Vector vector = PathToRoot$.MODULE$.$plus$colon$extension(acc, arrayIndex);
                    cursor = aCursor;
                    acc = vector;
                    continue;
                }
                if (cursorOp instanceof CursorOp.DownN) {
                    int n;
                    CursorOp.DownN downN = CursorOp$DownN$.MODULE$.unapply((CursorOp.DownN)cursorOp);
                    int n2 = n = downN._1();
                    ACursor aCursor = ACursor.lastCursorParentOrLastCursor$1(cursor);
                    PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply(n2);
                    Vector vector = PathToRoot$.MODULE$.$plus$colon$extension(acc, arrayIndex);
                    cursor = aCursor;
                    acc = vector;
                    continue;
                }
                if (CursorOp$MoveLeft$.MODULE$.equals(cursorOp)) {
                    ACursor aCursor = ACursor.lastCursorParentOrLastCursor$1(cursor);
                    PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply(-1);
                    Vector vector = PathToRoot$.MODULE$.$plus$colon$extension(acc, arrayIndex);
                    cursor = aCursor;
                    acc = vector;
                    continue;
                }
                if (CursorOp$MoveRight$.MODULE$.equals(cursorOp)) {
                    HCursor hCursor = cursor.lastCursor();
                    if (hCursor instanceof ArrayCursor) {
                        ArrayCursor lastCursor = (ArrayCursor)hCursor;
                        HCursor hCursor2 = lastCursor.parent();
                        PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply((long)lastCursor.indexValue() + 1L);
                        Vector vector = PathToRoot$.MODULE$.$plus$colon$extension(acc, arrayIndex);
                        cursor = hCursor2;
                        acc = vector;
                        continue;
                    }
                    cursor = cursor.lastCursor();
                    continue;
                }
                cursor = cursor.lastCursor();
                continue;
            }
            ACursor aCursor = cursor;
            if (aCursor instanceof ArrayCursor) {
                ArrayCursor cursor2 = (ArrayCursor)aCursor;
                HCursor hCursor = cursor2.parent();
                PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply(cursor2.indexValue());
                Vector vector = PathToRoot$.MODULE$.$plus$colon$extension(acc, arrayIndex);
                cursor = hCursor;
                acc = vector;
                continue;
            }
            if (aCursor instanceof ObjectCursor) {
                ObjectCursor cursor3 = (ObjectCursor)aCursor;
                HCursor hCursor = cursor3.parent();
                PathToRoot.PathElem.ObjectKey objectKey = PathToRoot$PathElem$ObjectKey$.MODULE$.apply(cursor3.keyValue());
                Vector vector = PathToRoot$.MODULE$.$plus$colon$extension(acc, objectKey);
                cursor = hCursor;
                acc = vector;
                continue;
            }
            if (aCursor instanceof TopCursor) {
                TopCursor cursor4 = (TopCursor)aCursor;
                return acc;
            }
            cursor = cursor.lastCursor();
        }
        return acc;
    }
}

