/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.compression.internal.operators;

import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import monix.reactive.compression.CompressionException$;
import scala.Array$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;

public final class InflateAdapter {
    private final Inflater inflater;
    private final byte[] buffer;

    public InflateAdapter(int bufferSize, boolean noWrap) {
        this.inflater = new Inflater(noWrap);
        this.buffer = new byte[bufferSize];
    }

    public byte[] finish() {
        byte[] byArray;
        try {
            if (!this.inflater.finished()) {
                throw CompressionException$.MODULE$.apply("Inflater is not finished when input stream completed", CompressionException$.MODULE$.apply$default$2());
            }
            this.inflater.reset();
            byArray = Array$.MODULE$.emptyByteArray();
        }
        catch (DataFormatException e) {
            throw CompressionException$.MODULE$.apply(e);
        }
        return byArray;
    }

    public byte[] onChunk(byte[] input) {
        byte[] byArray;
        try {
            this.inflater.setInput(input);
            byArray = this.pullAllOutput(input);
        }
        catch (DataFormatException e) {
            throw CompressionException$.MODULE$.apply(e);
        }
        return byArray;
    }

    private byte[] pullAllOutput(byte[] input) {
        return this.inflater.needsInput() ? Array$.MODULE$.emptyByteArray() : this.next$1(input, Array$.MODULE$.emptyByteArray());
    }

    public void close() {
        this.inflater.end();
    }

    private final byte[] next$1(byte[] input$1, byte[] acc) {
        byte[] current;
        byte[] byArray = acc;
        while (true) {
            int read = this.inflater.inflate(this.buffer);
            int remaining = this.inflater.getRemaining();
            current = Arrays.copyOf(this.buffer, read);
            if (remaining > 0) {
                if (read > 0) {
                    Object object = Predef$.MODULE$.byteArrayOps(byArray);
                    byArray = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)current, ClassTag$.MODULE$.apply(Byte.TYPE));
                    continue;
                }
                if (this.inflater.finished()) {
                    Object object = Predef$.MODULE$.byteArrayOps(input$1);
                    byte[] leftover = (byte[])ArrayOps$.MODULE$.takeRight$extension(object, remaining);
                    this.inflater.reset();
                    Object object2 = Predef$.MODULE$.byteArrayOps(leftover);
                    this.inflater.setInput((byte[])ArrayOps$.MODULE$.toArray$extension(object2, ClassTag$.MODULE$.apply(Byte.TYPE)));
                    Object object3 = Predef$.MODULE$.byteArrayOps(byArray);
                    byArray = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (Object)current, ClassTag$.MODULE$.apply(Byte.TYPE));
                    continue;
                }
                throw new Exception("read = 0, remaining > 0, not finished");
            }
            if (read <= 0) break;
            Object object = Predef$.MODULE$.byteArrayOps(byArray);
            byArray = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)current, ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        Object object = Predef$.MODULE$.byteArrayOps(byArray);
        return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)current, ClassTag$.MODULE$.apply(Byte.TYPE));
    }
}

