/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.reactive.Observable;
import monix.reactive.internal.builders.RangeObservable$;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class RangeObservable
extends Observable<Object> {
    private final long from;
    private final long until;
    private final long step;

    public static long $lessinit$greater$default$3() {
        return RangeObservable$.MODULE$.$lessinit$greater$default$3();
    }

    public RangeObservable(long from, long until, long step) {
        this.from = from;
        this.until = until;
        this.step = step;
        Predef$.MODULE$.require(step != 0L, RangeObservable::$init$$$anonfun$1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<Object> subscriber) {
        Cancelable cancelable;
        Scheduler s = subscriber.scheduler();
        if (!this.isRangeValid(this.from, this.until, this.step)) {
            subscriber.onComplete();
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            void var3_3;
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            this.loop(cancelable2, subscriber, s.executionModel(), this.from, 0, s);
            cancelable = var3_3;
        }
        return cancelable;
    }

    private void loop(BooleanCancelable c, Subscriber<Object> downstream, ExecutionModel em, long from, int syncIndex, Scheduler s) {
        block5: {
            int nextIndex;
            long nextFrom;
            Future<Ack> ack;
            RangeObservable rangeObservable = this;
            int n = syncIndex;
            long l = from;
            while (true) {
                int n2;
                ack = downstream.onNext(BoxesRunTime.boxToLong((long)l));
                nextFrom = l + rangeObservable.step;
                if (!rangeObservable.isNextInRange(l, nextFrom, rangeObservable.until, rangeObservable.step)) {
                    downstream.onComplete();
                    break block5;
                }
                Future<Ack> future = ack;
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(future != null ? !future.equals((Object)continue$) : continue$ != null)) {
                    n2 = em.nextFrameIndex(n);
                } else {
                    Future<Ack> future2 = ack;
                    Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                    n2 = !(future2 != null ? !future2.equals((Object)stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                }
                if (nextIndex <= 0) break;
                RangeObservable rangeObservable2 = rangeObservable;
                long l2 = nextFrom;
                int n3 = nextIndex;
                rangeObservable = rangeObservable2;
                l = l2;
                n = n3;
            }
            if (nextIndex == 0 && !c.isCanceled()) {
                rangeObservable.asyncBoundary(c, ack, downstream, em, nextFrom, s);
            }
        }
    }

    private void asyncBoundary(BooleanCancelable cancelable, Future<Ack> ack, Subscriber<Object> downstream, ExecutionModel em, long from, Scheduler s) {
        ack.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Ack success;
                Ack ack = success = (Ack)((Success)try_).value();
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(ack != null ? !ack.equals(continue$) : continue$ != null)) {
                    this.loop(cancelable, downstream, em, from, 0, s);
                }
            } else if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                s.reportFailure(ex);
            } else {
                throw new MatchError((Object)try_);
            }
        }, (ExecutionContext)s);
    }

    private boolean isRangeValid(long from, long until, long step) {
        return step > 0L && from < until || step < 0L && from > until;
    }

    private boolean isNextInRange(long from, long nextFrom, long until, long step) {
        return step > 0L && nextFrom < until && nextFrom > from || step < 0L && nextFrom > until && nextFrom < from;
    }

    private static final String $init$$$anonfun$1() {
        return "step != 0";
    }
}

