/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.execution.Ack;
import monix.execution.BufferCapacity;
import monix.execution.ChannelType;
import monix.execution.ChannelType$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.Platform$;
import monix.execution.internal.collection.LowLevelConcurrentQueue;
import monix.execution.internal.collection.LowLevelConcurrentQueue$;
import monix.execution.internal.math$;
import monix.reactive.observers.BufferedSubscriber;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.buffers.CommonBufferMembers;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public abstract class AbstractBackPressuredBufferedSubscriber<A, R>
extends CommonBufferMembers
implements BufferedSubscriber<A> {
    public final Subscriber<R> monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$out;
    private final int bufferSize;
    public final ExecutionModel monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$em;
    private final Scheduler scheduler;
    private final LowLevelConcurrentQueue queue;
    public final AtomicInt monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$itemsToPush;
    public final AtomicAny<Promise<Ack>> monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$backPressured;
    private final Runnable consumerRunLoop;

    public AbstractBackPressuredBufferedSubscriber(Subscriber<R> out, int _bufferSize, ChannelType.ProducerSide pt) {
        this.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$out = out;
        Predef$.MODULE$.require(_bufferSize > 0, AbstractBackPressuredBufferedSubscriber::$init$$$anonfun$1);
        this.bufferSize = math$.MODULE$.nextPowerOf2(_bufferSize);
        this.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$em = out.scheduler().executionModel();
        this.scheduler = out.scheduler();
        this.queue = LowLevelConcurrentQueue$.MODULE$.apply((BufferCapacity)BufferCapacity.Unbounded$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.min(Platform$.MODULE$.recommendedBufferChunkSize(), this.bufferSize)))), ChannelType$.MODULE$.assemble(pt, (ChannelType.ConsumerSide)ChannelType.SingleConsumer$.MODULE$), false);
        this.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$itemsToPush = AtomicBuilder.AtomicIntBuilder$.MODULE$.buildInstance(0, (PaddingStrategy)PaddingStrategy.LeftRight256$.MODULE$, true);
        Object initialValue$proxy1 = null;
        AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
        this.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$backPressured = (AtomicAny)builder$proxy1.buildInstance(initialValue$proxy1, (PaddingStrategy)PaddingStrategy.LeftRight256$.MODULE$, true);
        this.consumerRunLoop = new Runnable(this){
            private final /* synthetic */ AbstractBackPressuredBufferedSubscriber $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.fastLoop(this.$outer.lastIterationAck, 0, 0);
            }

            private final Future signalNext(Object next) {
                Ack ack;
                block9: {
                    try {
                        Ack ack2;
                        block11: {
                            block10: {
                                Ack ack3 = ack2 = this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$out.onNext(next);
                                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                                if (!(ack3 == null ? continue$ != null : !ack3.equals(continue$))) break block10;
                                Ack ack4 = ack2;
                                Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                                if (ack4 != null ? !ack4.equals(stop$) : stop$ != null) break block11;
                            }
                            ack = ack2;
                            break block9;
                        }
                        Option option = ack2.value();
                        if (option instanceof Some) {
                            Try try_ = (Try)((Some)option).value();
                            if (try_ instanceof Success) {
                                Ack success;
                                ack = success = (Ack)((Success)try_).value();
                                break block9;
                            }
                            if (try_ instanceof Failure) {
                                Throwable ex = ((Failure)try_).exception();
                                this.signalError(ex);
                                ack = Ack.Stop$.MODULE$;
                                break block9;
                            }
                        }
                        if (None$.MODULE$.equals(option)) {
                            ack = ack2;
                            break block9;
                        }
                        throw new MatchError((Object)option);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            this.signalError(ex);
                            ack = Ack.Stop$.MODULE$;
                        }
                        throw throwable;
                    }
                }
                return ack;
            }

            private final void signalComplete() {
                try {
                    this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$out.onComplete();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        this.$outer.scheduler().reportFailure(ex);
                    }
                    throw throwable;
                }
            }

            private final void signalError(Throwable ex) {
                try {
                    this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$out.onError(ex);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable err = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(err)) {
                        this.$outer.scheduler().reportFailure(err);
                    }
                    throw throwable;
                }
            }

            private final void goAsync(Object next, int nextSize, Future ack, int processed) {
                ack.onComplete((Function1)((JProcedure1 & Serializable)arg_0 -> this.goAsync$$anonfun$1(next, nextSize, ack, processed, arg_0)), (ExecutionContext)this.$outer.scheduler());
            }

            private void stopStreaming() {
                this.$outer.downstreamIsComplete = true;
                Promise bp = (Promise)this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$backPressured.get();
                if (bp != null) {
                    bp.success((Object)Ack.Stop$.MODULE$);
                }
            }

            private final void fastLoop(Future prevAck, int lastProcessed, int startIndex) {
                Ack.Continue$ ack;
                Ack.Continue$ continue$ = ack = prevAck == null ? Ack.Continue$.MODULE$ : prevAck;
                Ack.Continue$ continue$2 = Ack.Continue$.MODULE$;
                boolean isFirstIteration = !(continue$ != null ? !continue$.equals(continue$2) : continue$2 != null);
                int processed = lastProcessed;
                int nextIndex = startIndex;
                while (!this.$outer.downstreamIsComplete) {
                    R next = this.$outer.fetchNext();
                    if (next != null) {
                        int nextSize = this.$outer.fetchSize(next);
                        if (nextIndex > 0 || isFirstIteration) {
                            isFirstIteration = false;
                            Ack.Continue$ continue$3 = ack;
                            if (Ack.Continue$.MODULE$.equals(continue$3)) {
                                Ack.Continue$ continue$4 = ack = this.signalNext(next);
                                Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                                if (!(continue$4 != null ? !continue$4.equals(stop$) : stop$ != null)) {
                                    this.stopStreaming();
                                    return;
                                }
                                Ack.Continue$ continue$5 = ack;
                                Ack.Continue$ continue$6 = Ack.Continue$.MODULE$;
                                boolean isSync = !(continue$5 != null ? !continue$5.equals(continue$6) : continue$6 != null);
                                nextIndex = isSync ? this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$em.nextFrameIndex(nextIndex) : 0;
                                processed += nextSize;
                                continue;
                            }
                            if (Ack.Stop$.MODULE$.equals(continue$3)) {
                                this.stopStreaming();
                                return;
                            }
                            this.goAsync(next, nextSize, (Future)ack, processed);
                            return;
                        }
                        this.goAsync(next, nextSize, (Future)ack, processed);
                        return;
                    }
                    if (this.$outer.upstreamIsComplete) {
                        if (!this.$outer.queue().isEmpty()) continue;
                        this.stopStreaming();
                        this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$itemsToPush.decrement(processed + 1);
                        if (this.$outer.errorThrown != null) {
                            this.signalError(this.$outer.errorThrown);
                        } else {
                            this.signalComplete();
                        }
                        return;
                    }
                    this.$outer.lastIterationAck = ack;
                    int remaining = this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$itemsToPush.decrementAndGet(processed);
                    processed = 0;
                    if (remaining != 0) continue;
                    Promise bp = (Promise)this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$backPressured.getAndSet(null);
                    if (bp != null) {
                        bp.success((Object)Ack.Continue$.MODULE$);
                    }
                    return;
                }
            }

            /*
             * Unable to fully structure code
             */
            private final /* synthetic */ void goAsync$$anonfun$1(Object next$1, int nextSize$1, Future ack$1, int processed$1, Try x$1) {
                block7: {
                    block6: {
                        var6_6 = x$1;
                        if (!(var6_6 instanceof Success)) ** GOTO lbl-1000
                        var7_7 = (Ack)((Success)var6_6).value();
                        if (!Ack.Continue$.MODULE$.equals(var7_7)) break block6;
                        nextAck = this.signalNext(next$1);
                        v0 = ack$1;
                        var10_9 = Ack.Continue$.MODULE$;
                        if (!(v0 == null ? var10_9 != null : v0.equals(var10_9) == false)) ** GOTO lbl-1000
                        v1 = ack$1;
                        var11_10 = Ack.Stop$.MODULE$;
                        if (!(v1 != null ? v1.equals(var11_10) == false : var11_10 != null)) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        isSync = v2;
                        nextFrame = isSync != false ? this.$outer.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$em.nextFrameIndex(0) : 0;
                        this.fastLoop(nextAck, processed$1 + nextSize$1, nextFrame);
                        break block7;
                    }
                    if (Ack.Stop$.MODULE$.equals(var7_7)) {
                        this.stopStreaming();
                    } else if (var6_6 instanceof Failure) {
                        ex = ((Failure)var6_6).exception();
                        this.$outer.downstreamIsComplete = true;
                        this.signalError(ex);
                    } else {
                        throw new MatchError((Object)var6_6);
                    }
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{goAsync$$anonfun$1(java.lang.Object int scala.concurrent.Future int scala.util.Try )}, serializedLambda);
            }
        };
    }

    @Override
    public final Scheduler scheduler() {
        return this.scheduler;
    }

    public final LowLevelConcurrentQueue<A> queue() {
        return this.queue;
    }

    private final Future<Ack> pushOnNext(A elem, Option<Object> lastToPush) {
        Ack.Stop$ stop$;
        block8: {
            Promise promise;
            int toPush;
            AbstractBackPressuredBufferedSubscriber abstractBackPressuredBufferedSubscriber;
            block9: {
                Promise promise2;
                abstractBackPressuredBufferedSubscriber = this;
                Some some = lastToPush;
                while (true) {
                    int n;
                    if (abstractBackPressuredBufferedSubscriber.upstreamIsComplete || abstractBackPressuredBufferedSubscriber.downstreamIsComplete) {
                        stop$ = Ack.Stop$.MODULE$;
                        break block8;
                    }
                    if (elem == null) {
                        abstractBackPressuredBufferedSubscriber.onError(new NullPointerException("Null not supported in onNext"));
                        stop$ = Ack.Stop$.MODULE$;
                        break block8;
                    }
                    Some some2 = some;
                    if (None$.MODULE$.equals(some2)) {
                        n = abstractBackPressuredBufferedSubscriber.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$itemsToPush.getAndIncrement(abstractBackPressuredBufferedSubscriber.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$itemsToPush.getAndIncrement$default$1());
                    } else if (some2 instanceof Some) {
                        int v;
                        n = v = BoxesRunTime.unboxToInt((Object)((Some)some2).value());
                    } else {
                        throw new MatchError(some2);
                    }
                    toPush = n;
                    promise = (Promise)abstractBackPressuredBufferedSubscriber.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$backPressured.get();
                    if (promise != null) break block9;
                    if (toPush < abstractBackPressuredBufferedSubscriber.bufferSize) {
                        abstractBackPressuredBufferedSubscriber.queue().offer(elem);
                        abstractBackPressuredBufferedSubscriber.pushToConsumer(toPush);
                        stop$ = Ack.Continue$.MODULE$;
                        break block8;
                    }
                    promise2 = Promise$.MODULE$.apply();
                    if (abstractBackPressuredBufferedSubscriber.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$backPressured.compareAndSet(null, (Object)promise2)) break;
                    AbstractBackPressuredBufferedSubscriber abstractBackPressuredBufferedSubscriber2 = abstractBackPressuredBufferedSubscriber;
                    Some some3 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)toPush));
                    abstractBackPressuredBufferedSubscriber = abstractBackPressuredBufferedSubscriber2;
                    some = some3;
                }
                abstractBackPressuredBufferedSubscriber.queue().offer(elem);
                abstractBackPressuredBufferedSubscriber.pushToConsumer(toPush);
                stop$ = promise2.future();
                break block8;
            }
            Promise promise3 = promise;
            abstractBackPressuredBufferedSubscriber.queue().offer(elem);
            abstractBackPressuredBufferedSubscriber.pushToConsumer(toPush);
            stop$ = promise3.future();
        }
        return stop$;
    }

    @Override
    public final Future<Ack> onNext(A elem) {
        return this.pushOnNext(elem, (Option<Object>)None$.MODULE$);
    }

    private void pushComplete(Option<Throwable> ex, Option<Object> toPush) {
        if (!this.upstreamIsComplete && !this.downstreamIsComplete) {
            this.errorThrown = (Throwable)ex.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.upstreamIsComplete = true;
            int nr = BoxesRunTime.unboxToInt((Object)toPush.getOrElse(this::$anonfun$1));
            this.pushToConsumer(nr);
        }
    }

    @Override
    public final void onError(Throwable ex) {
        this.pushComplete((Option<Throwable>)Some$.MODULE$.apply((Object)ex), (Option<Object>)None$.MODULE$);
    }

    @Override
    public final void onComplete() {
        this.pushComplete((Option<Throwable>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    private final void pushToConsumer(int currentNr) {
        if (currentNr == 0) {
            this.scheduler().execute(this.consumerRunLoop);
        }
    }

    public abstract R fetchNext();

    public abstract int fetchSize(R var1);

    private static final String $init$$$anonfun$1() {
        return "bufferSize must be a strictly positive number";
    }

    private final int $anonfun$1() {
        return this.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$itemsToPush.getAndIncrement(this.monix$reactive$observers$buffers$AbstractBackPressuredBufferedSubscriber$$itemsToPush.getAndIncrement$default$1());
    }
}

