/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.subjects;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.Observable$;
import monix.reactive.internal.util.PromiseCounter;
import monix.reactive.internal.util.PromiseCounter$;
import monix.reactive.observers.ConnectableSubscriber;
import monix.reactive.observers.ConnectableSubscriber$;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.BehaviorSubject$;
import monix.reactive.subjects.BehaviorSubject$State$;
import monix.reactive.subjects.Subject;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class BehaviorSubject<A>
extends Subject<A, A> {
    private final AtomicAny<State<A>> stateRef;

    public static <A> BehaviorSubject<A> apply(A a) {
        return BehaviorSubject$.MODULE$.apply(a);
    }

    public BehaviorSubject(A initialValue) {
        State<A> initialValue$proxy1 = BehaviorSubject$State$.MODULE$.apply(initialValue, BehaviorSubject$State$.MODULE$.$lessinit$greater$default$2(), BehaviorSubject$State$.MODULE$.$lessinit$greater$default$3(), BehaviorSubject$State$.MODULE$.$lessinit$greater$default$4());
        AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
        this.stateRef = (AtomicAny)builder$proxy1.buildInstance(initialValue$proxy1, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }

    @Override
    public int size() {
        return ((State)this.stateRef.get()).subscribers().size();
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        return this.subscribeLoop$1(subscriber);
    }

    @Override
    public Future<Ack> onNext(A elem) {
        Future future;
        block9: {
            State<A> newState;
            State state;
            BehaviorSubject behaviorSubject = this;
            do {
                if (!(state = (State)behaviorSubject.stateRef.get()).isDone()) continue;
                future = Ack.Stop$.MODULE$;
                break block9;
            } while (!behaviorSubject.stateRef.compareAndSet((Object)state, newState = state.cacheElem(elem)));
            Iterator iterator = state.subscribers().iterator();
            ObjectRef result = ObjectRef.create(null);
            while (iterator.hasNext()) {
                Future future2;
                ConnectableSubscriber subscriber = (ConnectableSubscriber)iterator.next();
                try {
                    future2 = subscriber.onNext(elem);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        future2 = Future$.MODULE$.failed(ex);
                    }
                    throw throwable;
                }
                Future ack = future2;
                if (ack.isCompleted()) {
                    Future future3 = ack;
                    Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                    if (!(future3 == null ? continue$ != null : !future3.equals(continue$))) continue;
                    Object object = ack.value().get();
                    Success success = Ack.Continue$.MODULE$.AsSuccess();
                    if (!(object == null ? success != null : !object.equals(success))) continue;
                    behaviorSubject.removeSubscriber(subscriber);
                    continue;
                }
                if ((PromiseCounter)result.elem == null) {
                    PromiseCounter promiseCounter;
                    result.elem = promiseCounter = PromiseCounter$.MODULE$.apply(Ack.Continue$.MODULE$, 1);
                    promiseCounter = null;
                }
                ((PromiseCounter)result.elem).acquire();
                ack.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success && Ack.Continue$.MODULE$.equals(((Success)try_).value())) {
                        ((PromiseCounter)result$1.elem).countdown();
                    } else {
                        behaviorSubject.removeSubscriber(subscriber);
                        ((PromiseCounter)result$1.elem).countdown();
                    }
                }, (ExecutionContext)subscriber.scheduler());
            }
            if ((PromiseCounter)result.elem == null) {
                future = Ack.Continue$.MODULE$;
            } else {
                ((PromiseCounter)result.elem).countdown();
                future = ((PromiseCounter)result.elem).future();
            }
        }
        return future;
    }

    @Override
    public void onError(Throwable ex) {
        this.onCompleteOrError(ex);
    }

    @Override
    public void onComplete() {
        this.onCompleteOrError(null);
    }

    private void onCompleteOrError(Throwable ex) {
        State state;
        BehaviorSubject behaviorSubject = this;
        while (!(state = (State)behaviorSubject.stateRef.get()).isDone()) {
            if (!behaviorSubject.stateRef.compareAndSet((Object)state, state.markDone(ex))) continue;
            for (ConnectableSubscriber ref : state.subscribers()) {
                if (ex != null) {
                    ref.onError(ex);
                    continue;
                }
                ref.onComplete();
            }
        }
    }

    private void removeSubscriber(ConnectableSubscriber<A> s) {
        State<A> newState;
        State state;
        BehaviorSubject behaviorSubject = this;
        while (!behaviorSubject.stateRef.compareAndSet((Object)(state = (State)behaviorSubject.stateRef.get()), newState = state.removeSubscriber(s))) {
        }
    }

    private final Cancelable subscribeLoop$1(Subscriber subscriber$1) {
        Cancelable cancelable;
        block3: {
            ConnectableSubscriber c;
            State newState;
            State state;
            do {
                if ((state = (State)this.stateRef.get()).errorThrown() != null) {
                    subscriber$1.onError(state.errorThrown());
                    cancelable = Cancelable$.MODULE$.empty();
                } else {
                    if (!state.isDone()) continue;
                    cancelable = Observable$.MODULE$.now(state.cached()).unsafeSubscribeFn(subscriber$1);
                }
                break block3;
            } while (!this.stateRef.compareAndSet((Object)state, newState = state.addNewSubscriber(c = ConnectableSubscriber$.MODULE$.apply(subscriber$1))));
            c.pushFirst(state.cached());
            CancelableFuture<Ack> connecting = c.connect();
            Cancelable cancelable2 = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.removeSubscriber(c));
            CancelableFuture cancelableFuture = (CancelableFuture)Ack$.MODULE$.AckExtensions(connecting);
            Ack.AckExtensions$.MODULE$.syncOnStopOrFailure$extension((Future)cancelableFuture, (Function1)(JProcedure1 & Serializable)_$1 -> cancelable2.cancel(), (UncaughtExceptionReporter)subscriber$1.scheduler());
            cancelable = cancelable2;
        }
        return cancelable;
    }

    private static final class State<A>
    implements Product,
    Serializable {
        private final Object cached;
        private final Set subscribers;
        private final boolean isDone;
        private final Throwable errorThrown;

        public static <A> State<A> apply(A a, Set<ConnectableSubscriber<A>> set, boolean bl, Throwable throwable) {
            return BehaviorSubject$State$.MODULE$.apply(a, set, bl, throwable);
        }

        public static State<?> fromProduct(Product product) {
            return BehaviorSubject$State$.MODULE$.fromProduct(product);
        }

        public static <A> State<A> unapply(State<A> state) {
            return BehaviorSubject$State$.MODULE$.unapply(state);
        }

        public static <A> Set<ConnectableSubscriber<A>> $lessinit$greater$default$2() {
            return BehaviorSubject$State$.MODULE$.$lessinit$greater$default$2();
        }

        public static <A> boolean $lessinit$greater$default$3() {
            return BehaviorSubject$State$.MODULE$.$lessinit$greater$default$3();
        }

        public static <A> Throwable $lessinit$greater$default$4() {
            return BehaviorSubject$State$.MODULE$.$lessinit$greater$default$4();
        }

        public State(A cached, Set<ConnectableSubscriber<A>> subscribers, boolean isDone, Throwable errorThrown) {
            this.cached = cached;
            this.subscribers = subscribers;
            this.isDone = isDone;
            this.errorThrown = errorThrown;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.cached()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.subscribers()));
            n = Statics.mix((int)n, (int)(this.isDone() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.errorThrown()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.isDone() != state.isDone()) return false;
            if (!BoxesRunTime.equals(this.cached(), state.cached())) return false;
            Set<ConnectableSubscriber<A>> set = this.subscribers();
            Set<ConnectableSubscriber<A>> set2 = state.subscribers();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Throwable throwable = this.errorThrown();
            Throwable throwable2 = state.errorThrown();
            if (throwable == null) {
                if (throwable2 == null) return true;
                return false;
            } else {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "cached";
                    break;
                }
                case 1: {
                    string = "subscribers";
                    break;
                }
                case 2: {
                    string = "isDone";
                    break;
                }
                case 3: {
                    string = "errorThrown";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public A cached() {
            return (A)this.cached;
        }

        public Set<ConnectableSubscriber<A>> subscribers() {
            return this.subscribers;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public Throwable errorThrown() {
            return this.errorThrown;
        }

        public State<A> cacheElem(A elem) {
            return this.copy(elem, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public State<A> addNewSubscriber(ConnectableSubscriber<A> s) {
            Set set = (Set)this.subscribers().$plus(s);
            A a = this.copy$default$1();
            boolean bl = this.copy$default$3();
            Throwable throwable = this.copy$default$4();
            return this.copy(a, set, bl, throwable);
        }

        public State<A> removeSubscriber(ConnectableSubscriber<A> toRemove) {
            Set newSet = (Set)this.subscribers().$minus(toRemove);
            return this.copy(this.copy$default$1(), newSet, this.copy$default$3(), this.copy$default$4());
        }

        public State<A> markDone(Throwable ex) {
            Set set = Predef$.MODULE$.Set().empty();
            A a = this.copy$default$1();
            return this.copy(a, set, true, ex);
        }

        public <A> State<A> copy(A cached, Set<ConnectableSubscriber<A>> subscribers, boolean isDone, Throwable errorThrown) {
            return new State<A>(cached, subscribers, isDone, errorThrown);
        }

        public <A> A copy$default$1() {
            return this.cached();
        }

        public <A> Set<ConnectableSubscriber<A>> copy$default$2() {
            return this.subscribers();
        }

        public boolean copy$default$3() {
            return this.isDone();
        }

        public <A> Throwable copy$default$4() {
            return this.errorThrown();
        }

        public A _1() {
            return this.cached();
        }

        public Set<ConnectableSubscriber<A>> _2() {
            return this.subscribers();
        }

        public boolean _3() {
            return this.isDone();
        }

        public Throwable _4() {
            return this.errorThrown();
        }
    }
}

