/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl;

import ambience.bson.BsonETL$;
import ambience.etl.ETLURL$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;

public interface ETLURL {
    public static ETLURL apply(Document document, String string) {
        return ETLURL$.MODULE$.apply(document, string);
    }

    public InputStream openStream();

    public String protocol();

    public Option<File> optFile();

    public static class FieldURL
    implements ETLURL {
        private final Document record;
        private final String field;

        public FieldURL(Document record, String field) {
            this.record = record;
            this.field = field;
        }

        @Override
        public InputStream openStream() {
            Option option = BsonETL$.MODULE$.get(this.record, this.field);
            if (option instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option).value();
                if (bsonValue instanceof BsonBinary) {
                    BsonBinary bin = (BsonBinary)bsonValue;
                    return new ByteArrayInputStream(bin.getData());
                }
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return new ByteArrayInputStream(s.getValue().getBytes("UTF-8"));
                }
                BsonValue x = bsonValue;
                throw new IOException(this.field + " " + x + " is not bytes or a string");
            }
            if (None$.MODULE$.equals(option)) {
                throw new IOException("Missing field $x");
            }
            throw new MatchError((Object)option);
        }

        @Override
        public String protocol() {
            return "field";
        }

        @Override
        public Option<File> optFile() {
            return None$.MODULE$;
        }
    }

    public static class JavaURL
    implements ETLURL {
        private final URL url;

        public JavaURL(URL url) {
            this.url = url;
        }

        @Override
        public InputStream openStream() {
            return this.url.openStream();
        }

        @Override
        public String protocol() {
            return this.url.getProtocol();
        }

        @Override
        public Option<File> optFile() {
            String string = this.protocol();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return Some$.MODULE$.apply((Object)new File(this.url.getPath()));
            }
            return None$.MODULE$;
        }
    }
}

