/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl;

import ambience.SystemScheduler$;
import ambience.etl.AbstractETLLogger;
import ambience.etl.ETLPosition;
import ambience.etl.OpusConstants$;
import ambience.etl.runtime.JobResults$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import monix.reactive.OverflowStrategy;
import monix.reactive.observers.BufferedSubscriber$;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.Subscriber$;
import monix.reactive.subjects.PublishSubject;
import monix.reactive.subjects.PublishSubject$;
import org.bson.BsonInt64;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class JobLogger
extends AbstractETLLogger
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JobLogger.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String jobId;
    private final Scheduler scheduler;
    private long recordIdx;
    private final Task<CodexCollection> cltnT;
    private final Subscriber buffered;

    public JobLogger(CodexDB codexDB, Clock clock, String jobId) {
        this.jobId = jobId;
        super(clock);
        this.scheduler = SystemScheduler$.MODULE$.global();
        this.recordIdx = 0L;
        this.cltnT = codexDB.getTempCodexCollection(JobResults$.MODULE$.logCltn(jobId));
        PublishSubject subject = PublishSubject$.MODULE$.apply();
        this.buffered = BufferedSubscriber$.MODULE$.apply(Subscriber$.MODULE$.apply((Observer)subject, SystemScheduler$.MODULE$.global()), (OverflowStrategy)OverflowStrategy.Unbounded$.MODULE$, BufferedSubscriber$.MODULE$.apply$default$3());
        subject.map((Function1 & Serializable)doc -> {
            ++this.recordIdx;
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)OpusConstants$.MODULE$.ElxIdx());
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new BsonInt64(this.recordIdx)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }).flatMap((Function1 & Serializable)rec -> this.writeToDisk((Document)rec)).ignoreElements().toListL().onErrorRecover((PartialFunction)new Serializable(this){
            private final /* synthetic */ JobLogger $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception ex = (Exception)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception ex = (Exception)throwable;
                    this.$outer.log().error(() -> JobLogger.ambience$etl$JobLogger$$anon$1$$_$applyOrElse$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(32), FullName$.MODULE$.apply("ambience.etl.JobLogger"));
                    return package$.MODULE$.Nil();
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$etl$JobLogger$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Exception )}, serializedLambda);
            }
        }).runAsyncAndForget(this.scheduler());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Subscriber<Document> buffered() {
        return this.buffered;
    }

    private Task<BoxedUnit> onNext(Document doc) {
        return Task$.MODULE$.deferFuture(() -> this.onNext$$anonfun$1(doc)).map((Function1)(JProcedure1 & Serializable)_$1 -> {});
    }

    @Override
    public Task<BoxedUnit> initT() {
        return this.onNext(this.buildDocument("INFO", "Started " + this.jobId));
    }

    public Observable<BoxedUnit> writeToDisk(Document rec) {
        Task task = this.cltnT.flatMap((Function1 & Serializable)cltn -> cltn.insertOneT(rec).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            CodexDB.InsertOneResult insertOneResult = x$1;
        }));
        return Observable$.MODULE$.fromTask(task);
    }

    public Observable<BoxedUnit> writeToDisk(Seq<Document> seq) {
        Task task = seq.nonEmpty() ? this.cltnT.flatMap((Function1 & Serializable)_$2 -> _$2.insertManyT(seq)).map((Function1)(JProcedure1 & Serializable)_$3 -> {}) : Task$.MODULE$.unit();
        return Observable$.MODULE$.fromTask(task);
    }

    @Override
    public Task<BoxedUnit> errorT(ETLPosition pos, Function0<Object> message) {
        return this.onNext(this.buildDocument("ERROR", pos, message.apply()));
    }

    @Override
    public Task<BoxedUnit> errorT(Function0<Object> message, Throwable t) {
        return this.onNext(this.buildDocument("ERROR", message.apply(), t));
    }

    @Override
    public Task<BoxedUnit> errorT(ETLPosition pos, Function0<Object> message, Throwable t) {
        return this.onNext(this.buildDocument("ERROR", pos, message.apply(), t));
    }

    @Override
    public Task<BoxedUnit> warnT(ETLPosition pos, Function0<Object> message) {
        return this.onNext(this.buildDocument("WARN", pos, message.apply()));
    }

    @Override
    public Task<BoxedUnit> infoT(ETLPosition pos, Function0<Object> message) {
        return this.onNext(this.buildDocument("INFO", pos, message.apply()));
    }

    @Override
    public Task<BoxedUnit> debugT(ETLPosition pos, Function0<Object> message) {
        return this.onNext(this.buildDocument("DEBUG", pos, message.apply()));
    }

    @Override
    public Task<BoxedUnit> internalInfoT(Function0<Object> message) {
        return this.onNext(this.buildDocument("INFO", message.apply()));
    }

    @Override
    public Task<BoxedUnit> internalErrorT(Function0<Object> message) {
        return this.onNext(this.buildDocument("ERROR", message.apply()));
    }

    @Override
    public Task<BoxedUnit> cancelT() {
        return this.onNext(this.buildDocument("WARN", "Cancelled")).map((Function1)(JProcedure1 & Serializable)_$4 -> this.buffered().onComplete());
    }

    @Override
    public Task<BoxedUnit> completeT() {
        return this.onNext(this.buildDocument("INFO", "Completed")).map((Function1)(JProcedure1 & Serializable)_$5 -> this.buffered().onComplete());
    }

    @Override
    public Task<BoxedUnit> closeT() {
        return Task$.MODULE$.unit();
    }

    public static final Object ambience$etl$JobLogger$$anon$1$$_$applyOrElse$$anonfun$1(Exception ex$1) {
        return "Error writing job log: " + ex$1;
    }

    private final Future onNext$$anonfun$1(Document doc$1) {
        return this.buffered().onNext((Object)doc$1);
    }
}

