/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl;

import ambience.api.Jobs;
import ambience.api.Lifecycle;
import ambience.etl.BuildError;
import ambience.etl.ChainSetName$;
import ambience.etl.DefaultETLLogger$;
import ambience.etl.ETLChainSet;
import ambience.etl.ETLResults;
import ambience.etl.Helpers$;
import ambience.etl.RunningMessage;
import ambience.etl.RunningMessage$;
import ambience.etl.job.ChainBuilder;
import ambience.etl.runtime.JobHost;
import ambience.etl.runtime.JobManager;
import ambience.etl.runtime.JobResults;
import ambience.module.UserDB;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.Finished;
import com.elixirtech.arch.Finished$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.info.RunInfo;
import com.elixirtech.codex.CodexDB;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class JobsAPI
implements Jobs,
JobHost,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(JobsAPI.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JobsAPI.class.getDeclaredField("systemId$lzy1"));
    private volatile Object log$lzy1;
    private final CodexDB codexDB;
    private final RunInfo runInfo;
    private final Scheduler exeCxt;
    private final JobManager jobManager;
    private final ETLResults jobResults;
    private volatile Object systemId$lzy1;

    public JobsAPI(CodexDB codexDB, RunInfo runInfo) {
        this.codexDB = codexDB;
        this.runInfo = runInfo;
        this.exeCxt = Scheduler$.MODULE$.global();
        this.jobManager = new JobManager(this);
        this.jobResults = new JobResults(this);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public CodexDB codexDB() {
        return this.codexDB;
    }

    @Override
    public RunInfo runInfo() {
        return this.runInfo;
    }

    public Scheduler exeCxt() {
        return this.exeCxt;
    }

    @Override
    public JobManager jobManager() {
        return this.jobManager;
    }

    @Override
    public ETLResults jobResults() {
        return this.jobResults;
    }

    @Override
    public String systemId() {
        Object object = this.systemId$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.systemId$lzyINIT1();
    }

    private Object systemId$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.systemId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getString("ambience.systemId");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.systemId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Jobs.JobDefinition> startJob(UserDB.User user, Jobs.RunRequest runRequest) {
        String id = Jobs.JobId$.MODULE$.apply(UUID.randomUUID().toString());
        Jobs.JobDefinition jd = this.buildJobDefinition(id, user, runRequest);
        Task task = this.jobResults().start(user, jd.id()).flatMap((Function1 & Serializable)x$1 -> {
            Finished finished = x$1;
            return this.jobManager().start(jd).flatMap((Function1 & Serializable)x$12 -> {
                Finished finished = x$12;
                return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.$anonfun$1$$anonfun$1$$anonfun$1();
                    return BoxedUnit.UNIT;
                }).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return jd;
                });
            });
        });
        return ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).runJob(task).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().info(() -> JobsAPI.startJob$$anonfun$1$$anonfun$1(ex), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.etl.JobsAPI.startJob"));
            this.jobResults().removeOnErrorStarting(jd.id());
            throw ex;
        });
    }

    public Observable<Document> run(UserDB.User user, String chainset, String chainName, Observable<Document> init) {
        return Observable$.MODULE$.fromTask(this.jobManager().loadChainset(user, ChainSetName$.MODULE$.apply(chainset))).flatMap((Function1 & Serializable)chainSet -> {
            ChainBuilder builder = new ChainBuilder((ETLChainSet)chainSet, DefaultETLLogger$.MODULE$, user);
            Either<BuildError, Function1<Observable<Document>, Observable<Document>>> either = builder.buildChain((Option<String>)None$.MODULE$, chainName, (Option<Object>)None$.MODULE$);
            if (either instanceof Right) {
                Function1 flow = (Function1)((Right)either).value();
                return (Observable)flow.apply((Object)init);
            }
            if (either instanceof Left) {
                BuildError err = (BuildError)((Left)either).value();
                return Observable$.MODULE$.raiseError((Throwable)new RuntimeException("Error building chain: " + err.msg()));
            }
            throw new MatchError(either);
        });
    }

    public Task<Jobs.JobDefinition> runBatch(UserDB.User user, Jobs.RunRequest runRequest) {
        String id = Jobs.JobId$.MODULE$.apply(UUID.randomUUID().toString());
        Jobs.JobDefinition jd = this.buildJobDefinition(id, user, runRequest);
        return ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).runJob(this.jobResults().start(user, jd.id())).flatMap((Function1 & Serializable)x$12 -> {
            Finished finished = x$12;
            return this.jobManager().runBatch(jd, (Function1<Jobs.JobDefinition, Task<Finished>>)(Function1 & Serializable)_$1 -> Task$.MODULE$.now((Object)Finished$.MODULE$)).flatMap((Function1 & Serializable)x$1 -> {
                Finished finished = x$1;
                return this.jobManager().get(jd.id()).map((Function1 & Serializable)finalJD -> (Jobs.JobDefinition)finalJD.getOrElse(() -> JobsAPI.runBatch$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(jd)));
            });
        });
    }

    public Task<Jobs.JobDefinition> runBatch(UserDB.User user, Jobs.RunRequest runRequest, Function1<Jobs.JobDefinition, Task<Finished>> onStart) {
        String id = Jobs.JobId$.MODULE$.apply(UUID.randomUUID().toString());
        Jobs.JobDefinition jd = this.buildJobDefinition(id, user, runRequest);
        return ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).runJob(this.jobResults().start(user, jd.id())).flatMap((Function1 & Serializable)x$12 -> {
            Finished finished = x$12;
            return this.jobManager().runBatch(jd, onStart).flatMap((Function1 & Serializable)x$1 -> {
                Finished finished = x$1;
                return this.jobManager().get(jd.id()).map((Function1 & Serializable)finalJD -> (Jobs.JobDefinition)finalJD.getOrElse(() -> JobsAPI.runBatch$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(jd)));
            });
        });
    }

    public Task<Finished> stopJob(UserDB.User user, String id) {
        return this.jobManager().stop(user, id).map((Function1 & Serializable)_$2 -> Finished$.MODULE$);
    }

    public Observable<Jobs.JobDefinition> getJobs(String chainSetId) {
        return this.jobManager().getJobsInChain(chainSetId);
    }

    public Observable<Jobs.JobDefinition> getRunningJobs() {
        return this.jobManager().getRunning();
    }

    public Observable<Jobs.JobDefinition> getRecentJobs(FiniteDuration within) {
        return this.jobManager().getRecent(within);
    }

    public Observable<Jobs.JobDefinition> getJobsByOwner(String owner) {
        return this.jobManager().getByOwner(owner);
    }

    public Observable<Jobs.JobDefinition> getRecentJobsByOwner(String owner, FiniteDuration within) {
        return this.jobManager().getRecentByOwner(owner, within);
    }

    public Observable<Document> getResults(String id, int from, Option<Object> optCount) {
        return this.jobResults().getResults(id, from, optCount);
    }

    public Task<Document> getLogs(String id, int from, Option<Object> optCount) {
        return this.jobResults().getLogs(id, from, optCount).map((Function1 & Serializable)results -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"total");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToLong((long)results.total())), (BsonTransformer)BsonTransformer$.MODULE$.TransformLong());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"records");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, results.docs()), BsonTransformer$.MODULE$.transformSeq((BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument()));
            return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        });
    }

    public Task<Finished> deleteJob(UserDB.User user, String id) {
        if (!this.jobManager().isRunning(id)) {
            return this.jobResults().delete(user, id);
        }
        return Task$.MODULE$.raiseError((Throwable)new RuntimeException("Can't delete job " + new Jobs.JobId(id) + " while it is running."));
    }

    @Override
    public Task<Finished> notifyOwner(String id) {
        this.log().debug(() -> JobsAPI.notifyOwner$$anonfun$1(id), Line$.MODULE$.apply(116), FullName$.MODULE$.apply("ambience.etl.JobsAPI.notifyOwner"));
        return this.jobManager().get(id).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Jobs.JobDefinition jd = (Jobs.JobDefinition)((Some)option).value();
                String string = jd.mode();
                String string2 = "etl-designer";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    RunningMessage msg = RunningMessage$.MODULE$.apply("etl-running", Helpers$.MODULE$.running(jd));
                    this.log().debug(() -> JobsAPI.notifyOwner$$anonfun$2$$anonfun$1(jd, msg), Line$.MODULE$.apply(121), FullName$.MODULE$.apply("ambience.etl.JobsAPI.notifyOwner"));
                }
                return Finished$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> JobsAPI.notifyOwner$$anonfun$2$$anonfun$2(id), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.etl.JobsAPI.notifyOwner"));
                return Finished$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
    }

    private Jobs.JobDefinition buildJobDefinition(String id, UserDB.User user, Jobs.RunRequest runRequest) {
        long now = ((Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class))).now();
        return Jobs.JobDefinition$.MODULE$.apply(id, this.systemId(), this.runInfo().runId(), user.id(), user.name(), (Set)((SetOps)((IterableOps)user.roles().filter((Function1 & Serializable)_$3 -> _$3.enabled())).map((Function1 & Serializable)_$4 -> _$4.name())).$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{user.name()}))), runRequest.chainSetId(), runRequest.chainName(), runRequest.init(), runRequest.stepCount(), runRequest.mode(), now, now, (Option)None$.MODULE$, 0L, runRequest.chainName() + runRequest.stepCount().map((Function1 & Serializable)s -> JobsAPI.buildJobDefinition$$anonfun$3(BoxesRunTime.unboxToInt((Object)s))).getOrElse(JobsAPI::buildJobDefinition$$anonfun$4), "");
    }

    private static final Object $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "start completed ok";
    }

    private final void $anonfun$1$$anonfun$1$$anonfun$1() {
        this.log().info(JobsAPI::$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(37), FullName$.MODULE$.apply("ambience.etl.JobsAPI.task"));
    }

    private static final Object startJob$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "start completed failed with " + ex$1;
    }

    private static final Jobs.JobDefinition runBatch$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Jobs.JobDefinition jd$8) {
        return jd$8;
    }

    private static final Jobs.JobDefinition runBatch$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Jobs.JobDefinition jd$12) {
        return jd$12;
    }

    private static final Object notifyOwner$$anonfun$1(String id$1) {
        return "notifyOwner " + id$1;
    }

    private static final Object notifyOwner$$anonfun$2$$anonfun$1(Jobs.JobDefinition jd$13, RunningMessage msg$1) {
        return "notifyOwner(" + jd$13.owner() + "," + msg$1;
    }

    private static final Object notifyOwner$$anonfun$2$$anonfun$2(String id$3) {
        return "Can't notify " + new Jobs.JobId(id$3) + " - JobDefinition not found";
    }

    private static final /* synthetic */ String buildJobDefinition$$anonfun$3(int s) {
        return "[1-" + s + "]";
    }

    private static final String buildJobDefinition$$anonfun$4() {
        return "";
    }
}

