/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.job;

import ambience.etl.BuildError;
import ambience.etl.BuildError$;
import ambience.etl.Builder;
import ambience.etl.ChainSetId;
import ambience.etl.ChainSetId$;
import ambience.etl.ChainSetName;
import ambience.etl.ChainSetName$;
import ambience.etl.ETLChain;
import ambience.etl.ETLChainSet;
import ambience.etl.ETLLogger;
import ambience.etl.ETLPosition;
import ambience.etl.ETLPosition$;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType;
import ambience.etl.StepBuilderRegistry$;
import ambience.etl.job.ChainBuilder$;
import ambience.etl.job.DebugFlow;
import ambience.etl.package$Flow$;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import monix.reactive.Observable;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ChainBuilder
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ChainBuilder.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final ETLChainSet chainSet;
    private final ETLLogger logger;
    private final UserDB.User user;
    private final HashMap<String, BsonValue> dictionary;

    public static Builder.Context context(ChainBuilder chainBuilder, ETLPosition eTLPosition, boolean bl) {
        return ChainBuilder$.MODULE$.context(chainBuilder, eTLPosition, bl);
    }

    public static Option<String> prefix(String string) {
        return ChainBuilder$.MODULE$.prefix(string);
    }

    public ChainBuilder(ETLChainSet chainSet, ETLLogger logger, UserDB.User user) {
        this.chainSet = chainSet;
        this.logger = logger;
        this.user = user;
        this.dictionary = new HashMap();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ETLLogger logger() {
        return this.logger;
    }

    public UserDB.User user() {
        return this.user;
    }

    public ChainSetId chainSetId() {
        return ChainSetId$.MODULE$.apply(this.chainSet._id());
    }

    public ChainSetName chainSetName() {
        return ChainSetName$.MODULE$.apply(this.chainSet.name());
    }

    public String ownerId() {
        return this.user().id();
    }

    public String owner() {
        return this.user().name();
    }

    public Set<String> groups() {
        return (Set)((SetOps)((IterableOps)this.user().roles().filter((Function1 & Serializable)_$1 -> _$1.enabled())).map((Function1 & Serializable)_$2 -> _$2.name())).$plus((Object)this.user().name());
    }

    public Option<ETLChain> getChain(Option<String> prefix, String chainName) {
        String fullName = (String)prefix.map((Function1 & Serializable)p -> p + chainName).getOrElse(() -> ChainBuilder.$anonfun$2(chainName));
        Option ret = this.chainSet.chains().get((Object)fullName);
        if (ret.isEmpty()) {
            this.log().warn(() -> ChainBuilder.getChain$$anonfun$1(prefix, chainName), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.etl.job.ChainBuilder.getChain"));
        }
        return ret;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> buildChain(Option<String> prefix, String chainName, Option<Object> stepCount) {
        Option<ETLChain> option = this.getChain(prefix, chainName);
        if (option instanceof Some) {
            ETLChain chain = (ETLChain)((Some)option).value();
            Vector steps = (Vector)stepCount.map((Function1 & Serializable)n -> ChainBuilder.$anonfun$3(chain, BoxesRunTime.unboxToInt((Object)n))).getOrElse(() -> ChainBuilder.$anonfun$4(chain));
            return (Either)((IterableOnceOps)steps.zipWithIndex()).foldLeft((Object)package$.MODULE$.Right().apply(package$Flow$.MODULE$.bsonEmpty()), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Either bf = (Either)tuple2._1();
                    if (tuple22 != null) {
                        ETLStep node = (ETLStep)tuple22._1();
                        int idx = BoxesRunTime.unboxToInt((Object)tuple22._2());
                        if (node.disabled()) {
                            return bf;
                        }
                        ETLPosition pos = ETLPosition$.MODULE$.apply(chain.name(), node.name(), idx);
                        Builder.Context cxt = ChainBuilder$.MODULE$.context(this, pos, node.debug());
                        return bf.flatMap((Function1 & Serializable)f -> this.buildStep(cxt, node).map((Function1 & Serializable)g -> f.andThen(g)));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)BuildError$.MODULE$.apply("Chain " + chainName + " not found", BuildError$.MODULE$.$lessinit$greater$default$2(), BuildError$.MODULE$.$lessinit$greater$default$3()));
        }
        throw new MatchError(option);
    }

    public Option<Object> buildChain$default$3() {
        return None$.MODULE$;
    }

    public Set<String> chainNames() {
        return this.chainSet.chains().keySet();
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> buildStep(Builder.Context cxt, ETLStep node) {
        if (node.disabled()) {
            return package$.MODULE$.Right().apply((Function1 & Serializable)x -> (Observable)Predef$.MODULE$.identity(x));
        }
        return StepBuilderRegistry$.MODULE$.get(node.stepType()).toRight(() -> ChainBuilder.buildStep$$anonfun$2(node)).flatMap((Function1 & Serializable)builder -> builder.build(cxt, node).map((Function1 & Serializable)flow -> this.maybeDebugFlow(cxt, node, (Function1<Observable<Document>, Observable<Document>>)flow)));
    }

    public Function1<Observable<Document>, Observable<Document>> maybeDebugFlow(Builder.Context cxt, ETLStep node, Function1<Observable<Document>, Observable<Document>> flow) {
        if (node.debug()) {
            return new DebugFlow(cxt, flow);
        }
        return flow;
    }

    public void put(String key, Option<BsonValue> value) {
        Option<BsonValue> option = value;
        if (option instanceof Some) {
            BsonValue v = (BsonValue)((Some)option).value();
            v0 = this.dictionary.put((Object)key, (Object)v);
        } else if (None$.MODULE$.equals(option)) {
            v0 = this.dictionary.remove((Object)key);
        } else {
            throw new MatchError(option);
        }
    }

    public Option<BsonValue> get(String key) {
        return this.dictionary.get((Object)key);
    }

    private static final String $anonfun$2(String chainName$2) {
        return chainName$2;
    }

    private static final Object getChain$$anonfun$1(Option prefix$1, String chainName$3) {
        return "No chain found for getChain(" + prefix$1 + "," + chainName$3 + ")";
    }

    private static final /* synthetic */ Vector $anonfun$3(ETLChain chain$1, int n) {
        return chain$1.steps().take(n);
    }

    private static final Vector $anonfun$4(ETLChain chain$2) {
        return chain$2.steps();
    }

    private static final BuildError buildStep$$anonfun$2(ETLStep node$2) {
        return BuildError$.MODULE$.apply("Builder not found for " + new ETLStepType(node$2.stepType()), (Option<ETLStep>)Some$.MODULE$.apply((Object)node$2), BuildError$.MODULE$.$lessinit$greater$default$3());
    }
}

