/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.json;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.json.JWTDecoder;
import ambience.etl.json.JWTDecoder$Info$;
import ambience.etl.json.JWTDecoder$SecretNone$;
import ambience.etl.json.JWTDecoder$SecretPublicKey$;
import ambience.etl.json.JWTDecoder$SecretSecretKey$;
import ambience.etl.json.JWTDecoder$SecretString$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.apache.commons.codec.binary.Base64;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.collection.immutable.Document;
import pdi.jwt.Jwt$;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.JwtClaim;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtUnknownAlgorithm;
import pdi.jwt.algorithms.JwtUnknownAlgorithm$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JWTDecoder$
implements Builder,
PanelBuilder,
Serializable {
    public static final JWTDecoder$Info$ Info;
    public static final JWTDecoder$SecretNone$ SecretNone;
    public static final JWTDecoder$SecretString$ SecretString;
    public static final JWTDecoder$SecretPublicKey$ SecretPublicKey;
    public static final JWTDecoder$SecretSecretKey$ SecretSecretKey;
    private static final String stepType;
    public static final JWTDecoder$ MODULE$;

    private JWTDecoder$() {
    }

    static {
        MODULE$ = new JWTDecoder$();
        stepType = ETLStepType$.MODULE$.apply("json.JWTDecoder");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JWTDecoder$.class);
    }

    @Override
    public String stepType() {
        return stepType;
    }

    @Override
    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "secretField";
        String string2 = "jwtField";
        String string3 = "outputField";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JWTDecoder$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JWTDecoder$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JWTDecoder$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> MODULE$.run(cxt, (JWTDecoder.Info)info));
    }

    public Function1<Observable<Document>, Observable<Document>> run(Builder.Context cxt, JWTDecoder.Info info) {
        return (Function1 & Serializable)from -> from.mapEval((Function1 & Serializable)doc -> MODULE$.decode(cxt, info, (Document)doc));
    }

    public Task<Document> decode(Builder.Context cxt, JWTDecoder.Info info, Document doc) {
        Option option = BsonETL$.MODULE$.get(doc, info.jwtField());
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                Tuple2 tuple2;
                BsonString s = (BsonString)bsonValue;
                String jwt = s.getValue();
                Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(jwt), '.'));
                String header = new String(Base64.decodeBase64((String)((String)ArrayOps$.MODULE$.headOption$extension(object).getOrElse(JWTDecoder$::$anonfun$1))), StandardCharsets.UTF_8);
                Either parts = this.extractAlgorithm(header).flatMap((Function1 & Serializable)optAlg -> MODULE$.extractSecret(info, (Option<BsonValue>)BsonETL$.MODULE$.get(doc, info.secretField()), (Option<JwtAlgorithm>)optAlg).map((Function1 & Serializable)secret -> Tuple2$.MODULE$.apply(optAlg, secret)));
                Either either = parts;
                if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                    Option optAlg2 = (Option)tuple2._1();
                    JWTDecoder.Secret secret = (JWTDecoder.Secret)tuple2._2();
                    return this.extractValue(cxt, (Option<JwtAlgorithm>)optAlg2, secret, jwt).map((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            BsonValue value = (BsonValue)((Some)option).value();
                            return BsonETL$.MODULE$.put(doc, info.outputField(), value);
                        }
                        if (None$.MODULE$.equals(option)) {
                            return doc;
                        }
                        throw new MatchError((Object)option);
                    });
                }
                if (either instanceof Left) {
                    LogMessage err = (LogMessage)((Left)either).value();
                    return cxt.logRecord(doc, err);
                }
                throw new MatchError((Object)either);
            }
            BsonValue x = bsonValue;
            return cxt.logRecord(doc, (LogMessage)LogMessage.Error$.MODULE$.apply("JWT string token expected at " + info.jwtField() + ", got " + x));
        }
        if (None$.MODULE$.equals(option)) {
            return cxt.logRecord(doc, (LogMessage)LogMessage.Error$.MODULE$.apply("JWT string token missing at " + info.jwtField()));
        }
        throw new MatchError((Object)option);
    }

    public Task<Option<BsonValue>> extractValue(Builder.Context cxt, Option<JwtAlgorithm> optAlg, JWTDecoder.Secret secret, String jwt) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(optAlg, (Object)secret);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            JWTDecoder.Secret secret2 = (JWTDecoder.Secret)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                return this.logIssuesT(cxt, (Function0<Try<JwtClaim>>)((Function0 & Serializable)() -> JWTDecoder$.extractValue$$anonfun$1(jwt)));
            }
            if (option instanceof Some) {
                JwtAlgorithm jwtAlgorithm = (JwtAlgorithm)((Some)option).value();
                if (jwtAlgorithm instanceof JwtAsymmetricAlgorithm) {
                    JwtAsymmetricAlgorithm alg = (JwtAsymmetricAlgorithm)jwtAlgorithm;
                    if (secret2 instanceof JWTDecoder.SecretString) {
                        String string;
                        JWTDecoder.SecretString secretString = JWTDecoder$SecretString$.MODULE$.unapply((JWTDecoder.SecretString)secret2);
                        String ss = string = secretString._1();
                        return this.logIssuesT(cxt, (Function0<Try<JwtClaim>>)((Function0 & Serializable)() -> JWTDecoder$.extractValue$$anonfun$2(jwt, ss, alg)));
                    }
                }
                if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
                    JwtHmacAlgorithm alg = (JwtHmacAlgorithm)jwtAlgorithm;
                    if (secret2 instanceof JWTDecoder.SecretString) {
                        String string;
                        JWTDecoder.SecretString secretString = JWTDecoder$SecretString$.MODULE$.unapply((JWTDecoder.SecretString)secret2);
                        String ss = string = secretString._1();
                        return this.logIssuesT(cxt, (Function0<Try<JwtClaim>>)((Function0 & Serializable)() -> JWTDecoder$.extractValue$$anonfun$3(jwt, ss, alg)));
                    }
                }
                if (jwtAlgorithm instanceof JwtAsymmetricAlgorithm) {
                    JwtAsymmetricAlgorithm alg = (JwtAsymmetricAlgorithm)jwtAlgorithm;
                    if (secret2 instanceof JWTDecoder.SecretPublicKey) {
                        PublicKey publicKey;
                        JWTDecoder.SecretPublicKey secretPublicKey = JWTDecoder$SecretPublicKey$.MODULE$.unapply((JWTDecoder.SecretPublicKey)secret2);
                        PublicKey pk = publicKey = secretPublicKey._1();
                        return this.logIssuesT(cxt, (Function0<Try<JwtClaim>>)((Function0 & Serializable)() -> JWTDecoder$.extractValue$$anonfun$4(jwt, pk, alg)));
                    }
                }
                if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
                    JwtHmacAlgorithm alg = (JwtHmacAlgorithm)jwtAlgorithm;
                    if (secret2 instanceof JWTDecoder.SecretSecretKey) {
                        SecretKey secretKey;
                        JWTDecoder.SecretSecretKey secretSecretKey = JWTDecoder$SecretSecretKey$.MODULE$.unapply((JWTDecoder.SecretSecretKey)secret2);
                        SecretKey sk = secretKey = secretSecretKey._1();
                        return this.logIssuesT(cxt, (Function0<Try<JwtClaim>>)((Function0 & Serializable)() -> JWTDecoder$.extractValue$$anonfun$5(jwt, sk, alg)));
                    }
                }
            }
        }
        return cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply("Unexpected combination of " + optAlg + " and " + secret)).as((Object)None$.MODULE$);
    }

    public Either<LogMessage, JWTDecoder.Secret> extractSecret(JWTDecoder.Info info, Option<BsonValue> optValue, Option<JwtAlgorithm> optAlgorithm) {
        Option<JwtAlgorithm> option = optAlgorithm;
        if (option instanceof Some) {
            JwtAlgorithm alg = (JwtAlgorithm)((Some)option).value();
            Option<BsonValue> option2 = optValue;
            if (option2 instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option2).value();
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return scala.package$.MODULE$.Right().apply((Object)JWTDecoder$SecretString$.MODULE$.apply(s.getValue()));
                }
                if (bsonValue instanceof BsonBinary) {
                    BsonBinary b = (BsonBinary)bsonValue;
                    JwtAlgorithm jwtAlgorithm = alg;
                    if (jwtAlgorithm instanceof JwtAsymmetricAlgorithm) {
                        return this.buildPublicKey(info, b.getData());
                    }
                    if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
                        return this.buildSecretKey(info, b.getData());
                    }
                    if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
                        String string;
                        JwtUnknownAlgorithm jwtUnknownAlgorithm = JwtUnknownAlgorithm$.MODULE$.unapply((JwtUnknownAlgorithm)jwtAlgorithm);
                        String name = string = jwtUnknownAlgorithm._1();
                        return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Unknown algorithm: " + name));
                    }
                    throw new MatchError((Object)jwtAlgorithm);
                }
                BsonValue x = bsonValue;
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret key " + info.secretField() + " got " + x + ", expected string or bytes"));
            }
            if (None$.MODULE$.equals(option2)) {
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing secret key " + info.secretField()));
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Right().apply((Object)JWTDecoder$SecretNone$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Either<LogMessage, JWTDecoder.Secret> buildPublicKey(JWTDecoder.Info info, byte[] bytes) {
        Try try_ = Try$.MODULE$.apply(() -> JWTDecoder$.buildPublicKey$$anonfun$1(bytes));
        if (try_ instanceof Success) {
            PublicKey publicKey = (PublicKey)((Success)try_).value();
            return scala.package$.MODULE$.Right().apply((Object)JWTDecoder$SecretPublicKey$.MODULE$.apply(publicKey));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret " + info.secretField() + " cannot be decoded as RSA X509EncodedKeySpec: " + ex));
        }
        throw new MatchError((Object)try_);
    }

    public Either<LogMessage, JWTDecoder.Secret> buildSecretKey(JWTDecoder.Info info, byte[] bytes) {
        Try try_ = Try$.MODULE$.apply(() -> JWTDecoder$.buildSecretKey$$anonfun$1(bytes));
        if (try_ instanceof Success) {
            SecretKeySpec secretKey = (SecretKeySpec)((Success)try_).value();
            return scala.package$.MODULE$.Right().apply((Object)JWTDecoder$SecretSecretKey$.MODULE$.apply(secretKey));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret " + info.secretField() + " cannot be decoded as an AES SecretKeySpec: " + ex));
        }
        throw new MatchError((Object)try_);
    }

    public Either<LogMessage, Option<JwtAlgorithm>> extractAlgorithm(String header) {
        Either either = package$.MODULE$.parse(header);
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            Option optAlg = json.hcursor().downField("alg").focus().flatMap((Function1 & Serializable)_$1 -> _$1.asString());
            Option option = optAlg;
            if (option instanceof Some) {
                String alg;
                String string = alg = (String)((Some)option).value();
                String string2 = "none";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
                }
                Option option2 = JwtAlgorithm$.MODULE$.optionFromString(alg);
                if (option2 instanceof Some) {
                    JwtAlgorithm a = (JwtAlgorithm)((Some)option2).value();
                    return scala.package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)a));
                }
                if (None$.MODULE$.equals(option2)) {
                    return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Unknown algorithm " + alg));
                }
                throw new MatchError((Object)option2);
            }
            if (None$.MODULE$.equals(option)) {
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("No algorithm in " + header));
            }
            throw new MatchError((Object)option);
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Invalid header " + header + ": " + err));
        }
        throw new MatchError((Object)either);
    }

    @Override
    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "secretField";
        String string2 = "jwtField";
        String string3 = "outputField";
        int size = 3;
        JWTDecoder.Info info = (JWTDecoder.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JWTDecoder$::$anonfun$4, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JWTDecoder$::$anonfun$5, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JWTDecoder$::$anonfun$6))))).toOption().getOrElse(JWTDecoder$::$anonfun$7);
        Panel.Item secretField = PanelItem$.MODULE$.text("secretField", "Secret Field", info.secretField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item jwtField = PanelItem$.MODULE$.text("jwtField", "JWT Field", info.jwtField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item outputField = PanelItem$.MODULE$.text("outputField", "Output Field", info.outputField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> JWTDecoder$.buildPanel$$anonfun$1(secretField, jwtField, outputField));
    }

    @Override
    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> JWTDecoder$.savePanel$$anonfun$1(results, step));
    }

    public Task<Option<BsonValue>> logIssuesT(Builder.Context cxt, Function0<Try<JwtClaim>> fn) {
        Try try_ = (Try)fn.apply();
        if (try_ instanceof Success) {
            JwtClaim claim = (JwtClaim)((Success)try_).value();
            return Task$.MODULE$.now((Object)Some$.MODULE$.apply((Object)BsonDocument$.MODULE$.apply(claim.toJson())));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply("Encoding error: " + ex)).as((Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy1;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy1 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 build$$anonfun$2() {
        JWTDecoder$Info$ jWTDecoder$Info$ = JWTDecoder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JWTDecoder.Info)jWTDecoder$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final String $anonfun$1() {
        return "";
    }

    private static final Try extractValue$$anonfun$1(String jwt$1) {
        return Jwt$.MODULE$.decode(jwt$1);
    }

    private static final Seq extractValue$$anonfun$2$$anonfun$1(JwtAsymmetricAlgorithm alg$2) {
        return (Seq)new .colon.colon((Object)alg$2, (List)Nil$.MODULE$);
    }

    private static final Try extractValue$$anonfun$2(String jwt$2, String ss$1, JwtAsymmetricAlgorithm alg$1) {
        return Jwt$.MODULE$.decode(jwt$2, ss$1, () -> JWTDecoder$.extractValue$$anonfun$2$$anonfun$1(alg$1));
    }

    private static final Try extractValue$$anonfun$3(String jwt$3, String ss$2, JwtHmacAlgorithm alg$3) {
        return Jwt$.MODULE$.decode(jwt$3, ss$2, (Seq)new .colon.colon((Object)alg$3, (List)Nil$.MODULE$));
    }

    private static final Try extractValue$$anonfun$4(String jwt$4, PublicKey pk$1, JwtAsymmetricAlgorithm alg$4) {
        return Jwt$.MODULE$.decode(jwt$4, pk$1, (Seq)new .colon.colon((Object)alg$4, (List)Nil$.MODULE$));
    }

    private static final Try extractValue$$anonfun$5(String jwt$5, SecretKey sk$1, JwtHmacAlgorithm alg$5) {
        return Jwt$.MODULE$.decode(jwt$5, sk$1, (Seq)new .colon.colon((Object)alg$5, (List)Nil$.MODULE$));
    }

    private static final PublicKey buildPublicKey$$anonfun$1(byte[] bytes$1) {
        return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(bytes$1));
    }

    private static final SecretKeySpec buildSecretKey$$anonfun$1(byte[] bytes$2) {
        return new SecretKeySpec(bytes$2, "AES");
    }

    private static final List $anonfun$4() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy4 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy5 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy2;
        Configuration x$2$proxy6 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 $anonfun$5() {
        JWTDecoder$Info$ jWTDecoder$Info$ = JWTDecoder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JWTDecoder.Info)jWTDecoder$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$6() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final JWTDecoder.Info $anonfun$7() {
        return JWTDecoder$Info$.MODULE$.apply(JWTDecoder$Info$.MODULE$.$lessinit$greater$default$1(), JWTDecoder$Info$.MODULE$.$lessinit$greater$default$2(), JWTDecoder$Info$.MODULE$.$lessinit$greater$default$3());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item secretField$1, Panel.Item jwtField$1, Panel.Item outputField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)secretField$1, (List)new .colon.colon((Object)jwtField$1, (List)new .colon.colon((Object)outputField$1, (List)Nil$.MODULE$))));
    }

    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy7 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy8 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy3;
        Configuration x$2$proxy9 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        JWTDecoder$Info$ jWTDecoder$Info$ = JWTDecoder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JWTDecoder.Info)jWTDecoder$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JWTDecoder$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final List $anonfun$8() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        EncoderNotDeriveSum f$proxy4;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy4 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy10 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy4;
        Configuration x$2$proxy11 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy4;
        Configuration x$2$proxy12 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "secretField";
        String string2 = "jwtField";
        String string3 = "outputField";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JWTDecoder$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JWTDecoder$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JWTDecoder$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            JWTDecoder.Info info2 = (JWTDecoder.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "secretField";
            String string2 = "jwtField";
            String string3 = "outputField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(JWTDecoder$::$anonfun$8, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string4 = step$2.copy$default$1();
            String string5 = step$2.copy$default$2();
            String string6 = step$2.copy$default$3();
            String string7 = step$2.copy$default$4();
            String string8 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string4, string5, string6, string7, string8, json, bl, bl2);
        });
    }
}

