/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.json;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.json.JWTEncoder;
import ambience.etl.json.JWTEncoder$Info$;
import ambience.etl.json.JWTEncoder$SecretNone$;
import ambience.etl.json.JWTEncoder$SecretPrivateKey$;
import ambience.etl.json.JWTEncoder$SecretSecretKey$;
import ambience.etl.json.JWTEncoder$SecretString$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import pdi.jwt.Jwt$;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtUnknownAlgorithm;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JWTEncoder$
implements Builder,
PanelBuilder,
Serializable {
    public static final JWTEncoder$Info$ Info;
    public static final JWTEncoder$SecretNone$ SecretNone;
    public static final JWTEncoder$SecretString$ SecretString;
    public static final JWTEncoder$SecretPrivateKey$ SecretPrivateKey;
    public static final JWTEncoder$SecretSecretKey$ SecretSecretKey;
    private static final String stepType;
    private static final String BeginRSAPrivateKey;
    private static final String EndRSAPrivateKey;
    private static final String none;
    private static final String HMD5;
    private static final String HS224;
    private static final String HS256;
    private static final String HS384;
    private static final String HS512;
    private static final String RS256;
    private static final String RS384;
    private static final String RS512;
    private static final String ES256;
    private static final String ES384;
    private static final String ES512;
    private static final String Ed25519;
    private static final List AlgorithmChoices;
    public static final JWTEncoder$ MODULE$;

    private JWTEncoder$() {
    }

    static {
        MODULE$ = new JWTEncoder$();
        stepType = ETLStepType$.MODULE$.apply("json.JWTEncoder");
        BeginRSAPrivateKey = "-----BEGIN RSA PRIVATE KEY-----";
        EndRSAPrivateKey = "-----END RSA PRIVATE KEY-----";
        none = "none";
        HMD5 = "HMD5";
        HS224 = "HS224";
        HS256 = "HS256";
        HS384 = "HS384";
        HS512 = "HS512";
        RS256 = "RS256";
        RS384 = "RS384";
        RS512 = "RS512";
        ES256 = "ES256";
        ES384 = "ES384";
        ES512 = "ES512";
        Ed25519 = "Ed25519";
        AlgorithmChoices = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.SelectChoice[]{Panel.SelectChoice$.MODULE$.apply("none", Json$.MODULE$.fromString(MODULE$.none())), Panel.SelectChoice$.MODULE$.apply("HMD5", Json$.MODULE$.fromString(MODULE$.HMD5())), Panel.SelectChoice$.MODULE$.apply("HS224", Json$.MODULE$.fromString(MODULE$.HS224())), Panel.SelectChoice$.MODULE$.apply("HS256", Json$.MODULE$.fromString(MODULE$.HS256())), Panel.SelectChoice$.MODULE$.apply("HS384", Json$.MODULE$.fromString(MODULE$.HS384())), Panel.SelectChoice$.MODULE$.apply("HS512", Json$.MODULE$.fromString(MODULE$.HS512())), Panel.SelectChoice$.MODULE$.apply("RS256", Json$.MODULE$.fromString(MODULE$.RS256())), Panel.SelectChoice$.MODULE$.apply("RS384", Json$.MODULE$.fromString(MODULE$.RS384())), Panel.SelectChoice$.MODULE$.apply("RS512", Json$.MODULE$.fromString(MODULE$.RS512())), Panel.SelectChoice$.MODULE$.apply("ES256", Json$.MODULE$.fromString(MODULE$.ES256())), Panel.SelectChoice$.MODULE$.apply("ES384", Json$.MODULE$.fromString(MODULE$.ES384())), Panel.SelectChoice$.MODULE$.apply("ES512", Json$.MODULE$.fromString(MODULE$.ES512())), Panel.SelectChoice$.MODULE$.apply("Ed25519", Json$.MODULE$.fromString(MODULE$.Ed25519()))}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JWTEncoder$.class);
    }

    @Override
    public String stepType() {
        return stepType;
    }

    public String BeginRSAPrivateKey() {
        return BeginRSAPrivateKey;
    }

    public String EndRSAPrivateKey() {
        return EndRSAPrivateKey;
    }

    public String none() {
        return none;
    }

    public String HMD5() {
        return HMD5;
    }

    public String HS224() {
        return HS224;
    }

    public String HS256() {
        return HS256;
    }

    public String HS384() {
        return HS384;
    }

    public String HS512() {
        return HS512;
    }

    public String RS256() {
        return RS256;
    }

    public String RS384() {
        return RS384;
    }

    public String RS512() {
        return RS512;
    }

    public String ES256() {
        return ES256;
    }

    public String ES384() {
        return ES384;
    }

    public String ES512() {
        return ES512;
    }

    public String Ed25519() {
        return Ed25519;
    }

    public List<Panel.SelectChoice> AlgorithmChoices() {
        return AlgorithmChoices;
    }

    @Override
    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "algorithm";
        String string2 = "secretField";
        String string3 = "payloadField";
        String string4 = "outputField";
        int size = 4;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JWTEncoder$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JWTEncoder$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JWTEncoder$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> MODULE$.run(cxt, (JWTEncoder.Info)info));
    }

    public Function1<Observable<Document>, Observable<Document>> run(Builder.Context cxt, JWTEncoder.Info info) {
        return (Function1 & Serializable)from -> from.mapEval((Function1 & Serializable)doc -> {
            Option secret = BsonETL$.MODULE$.get((Document)doc, info.secretField());
            Option payload = BsonETL$.MODULE$.get((Document)doc, info.payloadField());
            return MODULE$.encode(cxt, info, (Option<BsonValue>)secret, (Option<BsonValue>)payload).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    BsonValue output = (BsonValue)((Some)option).value();
                    return BsonETL$.MODULE$.put((Document)doc, info.outputField(), output);
                }
                if (None$.MODULE$.equals(option)) {
                    return doc;
                }
                throw new MatchError((Object)option);
            });
        });
    }

    public Task<Option<BsonValue>> encode(Builder.Context cxt, JWTEncoder.Info info, Option<BsonValue> optSecret, Option<BsonValue> optPayload) {
        Tuple3 tuple3;
        Either parts = this.extractPayload(info, optPayload).flatMap((Function1 & Serializable)payload -> MODULE$.extractOptAlgorithm(info).flatMap((Function1 & Serializable)optAlgorithm -> MODULE$.extractSecret(info, optSecret, (Option<JwtAlgorithm>)optAlgorithm).map((Function1 & Serializable)secret -> Tuple3$.MODULE$.apply(payload, optAlgorithm, secret))));
        Either either = parts;
        if (either instanceof Right && (tuple3 = (Tuple3)((Right)either).value()) != null) {
            String payload2 = (String)tuple3._1();
            Option optAlgorithm = (Option)tuple3._2();
            JWTEncoder.Secret secret = (JWTEncoder.Secret)tuple3._3();
            return this.extractValue(cxt, (Option<JwtAlgorithm>)optAlgorithm, secret, payload2);
        }
        if (either instanceof Left) {
            String err = (String)((Left)either).value();
            return cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply(err)).as((Object)None$.MODULE$);
        }
        throw new MatchError((Object)either);
    }

    public Task<Option<BsonValue>> extractValue(Builder.Context cxt, Option<JwtAlgorithm> optAlg, JWTEncoder.Secret secret, String payload) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(optAlg, (Object)secret);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            JWTEncoder.Secret secret2 = (JWTEncoder.Secret)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                return this.logIssuesT(cxt, (Function0<String>)((Function0 & Serializable)() -> JWTEncoder$.extractValue$$anonfun$1(payload)));
            }
            if (option instanceof Some) {
                JwtAlgorithm jwtAlgorithm;
                JwtAlgorithm alg = jwtAlgorithm = (JwtAlgorithm)((Some)option).value();
                if (secret2 instanceof JWTEncoder.SecretString) {
                    String string;
                    JWTEncoder.SecretString secretString = JWTEncoder$SecretString$.MODULE$.unapply((JWTEncoder.SecretString)secret2);
                    String ss = string = secretString._1();
                    return this.logIssuesT(cxt, (Function0<String>)((Function0 & Serializable)() -> JWTEncoder$.extractValue$$anonfun$2(payload, ss, alg)));
                }
                if (jwtAlgorithm instanceof JwtAsymmetricAlgorithm) {
                    JwtAsymmetricAlgorithm alg2 = (JwtAsymmetricAlgorithm)jwtAlgorithm;
                    if (secret2 instanceof JWTEncoder.SecretPrivateKey) {
                        PrivateKey privateKey;
                        JWTEncoder.SecretPrivateKey secretPrivateKey = JWTEncoder$SecretPrivateKey$.MODULE$.unapply((JWTEncoder.SecretPrivateKey)secret2);
                        PrivateKey pk = privateKey = secretPrivateKey._1();
                        return this.logIssuesT(cxt, (Function0<String>)((Function0 & Serializable)() -> JWTEncoder$.extractValue$$anonfun$3(payload, pk, alg2)));
                    }
                }
                if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
                    JwtHmacAlgorithm alg3 = (JwtHmacAlgorithm)jwtAlgorithm;
                    if (secret2 instanceof JWTEncoder.SecretSecretKey) {
                        SecretKey secretKey;
                        JWTEncoder.SecretSecretKey secretSecretKey = JWTEncoder$SecretSecretKey$.MODULE$.unapply((JWTEncoder.SecretSecretKey)secret2);
                        SecretKey sk = secretKey = secretSecretKey._1();
                        return this.logIssuesT(cxt, (Function0<String>)((Function0 & Serializable)() -> JWTEncoder$.extractValue$$anonfun$4(payload, sk, alg3)));
                    }
                }
            }
        }
        return cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply("Unexpected combination of " + optAlg + " and " + secret)).as((Object)None$.MODULE$);
    }

    public Either<String, Option<JwtAlgorithm>> extractOptAlgorithm(JWTEncoder.Info info) {
        String string = info.algorithm();
        String string2 = this.none();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        return JwtAlgorithm$.MODULE$.optionFromString(info.algorithm()).toRight(() -> JWTEncoder$.extractOptAlgorithm$$anonfun$1(info)).map((Function1 & Serializable)_$1 -> Some$.MODULE$.apply(_$1));
    }

    public Either<String, String> extractPayload(JWTEncoder.Info info, Option<BsonValue> payload) {
        Option<BsonValue> option = payload;
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonDocument) {
                BsonDocument bd = (BsonDocument)bsonValue;
                return scala.package$.MODULE$.Right().apply((Object)bd.toJson());
            }
            BsonValue x = bsonValue;
            return scala.package$.MODULE$.Left().apply((Object)("Payload " + info.payloadField() + " is " + x + ", document expected"));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)("Payload " + info.payloadField() + " is missing"));
        }
        throw new MatchError(option);
    }

    public Either<String, JWTEncoder.Secret> extractSecret(JWTEncoder.Info info, Option<BsonValue> secret, Option<JwtAlgorithm> optAlg) {
        if (optAlg.isEmpty()) {
            return scala.package$.MODULE$.Right().apply((Object)JWTEncoder$SecretNone$.MODULE$);
        }
        Option<BsonValue> option = secret;
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return scala.package$.MODULE$.Right().apply((Object)JWTEncoder$SecretString$.MODULE$.apply(s.getValue().trim()));
            }
            if (bsonValue instanceof BsonBinary) {
                BsonBinary b = (BsonBinary)bsonValue;
                Option<JwtAlgorithm> option2 = optAlg;
                if (option2 instanceof Some) {
                    JwtAlgorithm jwtAlgorithm = (JwtAlgorithm)((Some)option2).value();
                    if (jwtAlgorithm instanceof JwtAsymmetricAlgorithm) {
                        Try try_ = Try$.MODULE$.apply(() -> JWTEncoder$.extractSecret$$anonfun$1(b));
                        if (try_ instanceof Success) {
                            PrivateKey privateKey = (PrivateKey)((Success)try_).value();
                            return scala.package$.MODULE$.Right().apply((Object)JWTEncoder$SecretPrivateKey$.MODULE$.apply(privateKey));
                        }
                        if (try_ instanceof Failure) {
                            Throwable ex = ((Failure)try_).exception();
                            return scala.package$.MODULE$.Left().apply((Object)("Secret " + info.secretField() + " cannot be decoded as RSA PKCS8EncodedKeySpec: " + ex));
                        }
                        throw new MatchError((Object)try_);
                    }
                    if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
                        Try try_ = Try$.MODULE$.apply(() -> JWTEncoder$.extractSecret$$anonfun$2(b));
                        if (try_ instanceof Success) {
                            SecretKeySpec secretKey = (SecretKeySpec)((Success)try_).value();
                            return scala.package$.MODULE$.Right().apply((Object)JWTEncoder$SecretSecretKey$.MODULE$.apply(secretKey));
                        }
                        if (try_ instanceof Failure) {
                            Throwable ex = ((Failure)try_).exception();
                            return scala.package$.MODULE$.Left().apply((Object)("Secret " + info.secretField() + " cannot be decoded as an AES SecretKeySpec: " + ex));
                        }
                        throw new MatchError((Object)try_);
                    }
                    if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
                        JwtUnknownAlgorithm x = (JwtUnknownAlgorithm)jwtAlgorithm;
                        return scala.package$.MODULE$.Left().apply((Object)("Unknown algorithm " + x.fullName()));
                    }
                }
                if (None$.MODULE$.equals(option2)) {
                    return scala.package$.MODULE$.Right().apply((Object)JWTEncoder$SecretNone$.MODULE$);
                }
                throw new MatchError(option2);
            }
            BsonValue x = bsonValue;
            return scala.package$.MODULE$.Left().apply((Object)("Secret " + info.secretField() + " is " + x + ", string or bytes expected"));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)("Secret " + info.secretField() + " is missing"));
        }
        throw new MatchError(option);
    }

    public Task<Option<BsonValue>> logIssuesT(Builder.Context cxt, Function0<String> fn) {
        Try try_ = Try$.MODULE$.apply(fn);
        if (try_ instanceof Success) {
            String s = (String)((Success)try_).value();
            return Task$.MODULE$.now((Object)Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(s)));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply("Encoding error: " + ex)).as((Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "algorithm";
        String string2 = "secretField";
        String string3 = "payloadField";
        String string4 = "outputField";
        int size = 4;
        JWTEncoder.Info info = (JWTEncoder.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JWTEncoder$::$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JWTEncoder$::$anonfun$3, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JWTEncoder$::$anonfun$4))))).toOption().getOrElse(JWTEncoder$::$anonfun$5);
        Panel.Item algorithm = PanelItem$.MODULE$.select("algorithm", "Algorithm", Json$.MODULE$.fromString(info.algorithm()), this.AlgorithmChoices(), PanelItem$.MODULE$.select$default$5());
        Panel.Item secretField = PanelItem$.MODULE$.text("secretField", "Secret Field", info.secretField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item payloadField = PanelItem$.MODULE$.text("payloadField", "Payload Field", info.payloadField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item outputField = PanelItem$.MODULE$.text("outputField", "Output Field", info.outputField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> JWTEncoder$.buildPanel$$anonfun$1(algorithm, secretField, payloadField, outputField));
    }

    @Override
    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> JWTEncoder$.savePanel$$anonfun$1(results, step));
    }

    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        DecoderNotDeriveSum f$proxy1;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy1 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy1;
        Configuration x$2$proxy4 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 build$$anonfun$2() {
        JWTEncoder$Info$ jWTEncoder$Info$ = JWTEncoder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JWTEncoder.Info)jWTEncoder$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final String extractValue$$anonfun$1(String payload$3) {
        return Jwt$.MODULE$.encode(payload$3);
    }

    private static final String extractValue$$anonfun$2(String payload$4, String ss$1, JwtAlgorithm alg$1) {
        return Jwt$.MODULE$.encode(payload$4, ss$1, alg$1);
    }

    private static final String extractValue$$anonfun$3(String payload$5, PrivateKey pk$1, JwtAsymmetricAlgorithm alg$2) {
        return Jwt$.MODULE$.encode(payload$5, pk$1, alg$2);
    }

    private static final String extractValue$$anonfun$4(String payload$6, SecretKey sk$1, JwtHmacAlgorithm alg$3) {
        return Jwt$.MODULE$.encode(payload$6, sk$1, alg$3);
    }

    private static final String extractOptAlgorithm$$anonfun$1(JWTEncoder.Info info$6) {
        return "Algorithm unknown: " + info$6.algorithm();
    }

    private static final PrivateKey extractSecret$$anonfun$1(BsonBinary b$1) {
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(b$1.getData()));
    }

    private static final SecretKeySpec extractSecret$$anonfun$2(BsonBinary b$2) {
        return new SecretKeySpec(b$2.getData(), "AES");
    }

    private static final List $anonfun$2() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy5 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy6 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy2;
        Configuration x$2$proxy7 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy2;
        Configuration x$2$proxy8 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 $anonfun$3() {
        JWTEncoder$Info$ jWTEncoder$Info$ = JWTEncoder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JWTEncoder.Info)jWTEncoder$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$4() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final JWTEncoder.Info $anonfun$5() {
        return JWTEncoder$Info$.MODULE$.apply(JWTEncoder$Info$.MODULE$.$lessinit$greater$default$1(), JWTEncoder$Info$.MODULE$.$lessinit$greater$default$2(), JWTEncoder$Info$.MODULE$.$lessinit$greater$default$3(), JWTEncoder$Info$.MODULE$.$lessinit$greater$default$4());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item algorithm$1, Panel.Item secretField$1, Panel.Item payloadField$1, Panel.Item outputField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)algorithm$1, (List)new .colon.colon((Object)secretField$1, (List)new .colon.colon((Object)payloadField$1, (List)new .colon.colon((Object)outputField$1, (List)Nil$.MODULE$)))));
    }

    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy9 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy10 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy3;
        Configuration x$2$proxy11 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy3;
        Configuration x$2$proxy12 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        JWTEncoder$Info$ jWTEncoder$Info$ = JWTEncoder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JWTEncoder.Info)jWTEncoder$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JWTEncoder$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final List $anonfun$6() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        EncoderNotDeriveSum f$proxy4;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy4 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy13 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy4;
        Configuration x$2$proxy14 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy4;
        Configuration x$2$proxy15 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this4 = f$proxy4;
        Configuration x$2$proxy16 = EncoderNotDeriveSum_this4.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder4 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "algorithm";
        String string2 = "secretField";
        String string3 = "payloadField";
        String string4 = "outputField";
        int size = 4;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JWTEncoder$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JWTEncoder$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JWTEncoder$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            JWTEncoder.Info info2 = (JWTEncoder.Info)package$.MODULE$.EncoderOps(info);
            String string = "algorithm";
            String string2 = "secretField";
            String string3 = "payloadField";
            String string4 = "outputField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(JWTEncoder$::$anonfun$6, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string5 = step$2.copy$default$1();
            String string6 = step$2.copy$default$2();
            String string7 = step$2.copy$default$3();
            String string8 = step$2.copy$default$4();
            String string9 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string5, string6, string7, string8, string9, json, bl, bl2);
        });
    }
}

