/*
 * Decompiled with CFR 0.152.
 */
package ambience.scheduler;

import ambience.scheduler.SchedulerModule$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingMixin;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.LazyList;
import scala.package$;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface FireTimeStream {
    public String displayString();

    public Option<ZonedDateTime> getFireTimeAfter(ZonedDateTime var1);

    public Clock clock();

    public static LazyList fireTimesStream$(FireTimeStream $this, ZonedDateTime start) {
        return $this.fireTimesStream(start);
    }

    default public LazyList<ZonedDateTime> fireTimesStream(ZonedDateTime start) {
        Option<ZonedDateTime> option = this.getSafeFireTimeAfter(start);
        if (option instanceof Some) {
            ZonedDateTime d = (ZonedDateTime)((Some)option).value();
            package$.MODULE$.LazyList();
            return LazyList.cons$.MODULE$.apply(() -> this.fireTimesStream$$anonfun$1(d), () -> this.fireTimesStream$$anonfun$2(d));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.LazyList().empty();
        }
        throw new MatchError(option);
    }

    public static Option getSafeFireTimeAfter$(FireTimeStream $this, ZonedDateTime start) {
        return $this.getSafeFireTimeAfter(start);
    }

    default public Option<ZonedDateTime> getSafeFireTimeAfter(ZonedDateTime start) {
        ZonedDateTime startMarker = this.earliest();
        ZonedDateTime endMarker = this.latest();
        boolean found = false;
        ZonedDateTime from = start;
        None$ ret = None$.MODULE$;
        while (!found) {
            Option<ZonedDateTime> option = this.getFireTimeAfter(from);
            if (None$.MODULE$.equals(option)) {
                found = true;
                continue;
            }
            if (option instanceof Some) {
                ZonedDateTime d = (ZonedDateTime)((Some)option).value();
                if (!d.isAfter(from)) {
                    ((LoggingMixin)this).log().warn(this::getSafeFireTimeAfter$$anonfun$1, Line$.MODULE$.apply(34), FullName$.MODULE$.apply("ambience.scheduler.FireTimeStream.getSafeFireTimeAfter"));
                    found = true;
                    continue;
                }
                if (d.isAfter(endMarker)) {
                    found = true;
                    continue;
                }
                if (d.isBefore(startMarker)) {
                    from = d;
                    continue;
                }
                ret = Some$.MODULE$.apply((Object)d);
                found = true;
                continue;
            }
            throw new MatchError(option);
        }
        return ret;
    }

    private ZonedDateTime fixGaps(ZonedDateTime d) {
        return (ZonedDateTime)Option$.MODULE$.apply((Object)d.getZone().getRules().getTransition(d.toLocalDateTime())).map((Function1 & Serializable)conflict -> {
            if (conflict.isGap()) {
                return conflict.getDateTimeAfter().atZone(d.getZone());
            }
            return d;
        }).getOrElse(() -> FireTimeStream.fixGaps$$anonfun$2(d));
    }

    private ZonedDateTime earliest() {
        return Instant.ofEpochMilli(this.clock().now() - SchedulerModule$.MODULE$.MISFIRE_THRESHOLD()).atZone(ZoneId.systemDefault());
    }

    private ZonedDateTime latest() {
        return Instant.ofEpochMilli(this.clock().now()).atZone(ZoneId.systemDefault()).plusYears(Int$.MODULE$.int2long(SchedulerModule$.MODULE$.WindowYears()));
    }

    private ZonedDateTime fireTimesStream$$anonfun$1(ZonedDateTime d$1) {
        return this.fixGaps(d$1);
    }

    private LazyList fireTimesStream$$anonfun$2(ZonedDateTime d$2) {
        return this.fireTimesStream(d$2);
    }

    private Object getSafeFireTimeAfter$$anonfun$1() {
        return "Next fire time not advancing for " + this.displayString();
    }

    private static ZonedDateTime fixGaps$$anonfun$2(ZonedDateTime d$4) {
        return d$4;
    }
}

